/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.google.common.base.Function;
import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.OperationNotFoundException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.expressions.model.Operator;
import com.lyncode.jtwig.expressions.operations.BinaryOperator;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import java.util.ArrayList;
import java.util.List;

public class OperationBinary
extends AbstractCompilableExpression {
    private List<CompilableExpression> operands = new ArrayList<CompilableExpression>();
    private List<Operator> operators = new ArrayList<Operator>();

    public OperationBinary(JtwigPosition position, CompilableExpression operand) {
        super(position);
        this.operands.add(operand);
    }

    public OperationBinary add(Operator operator) {
        this.operators.add(operator);
        return this;
    }

    public OperationBinary add(CompilableExpression operand) {
        this.operands.add(operand);
        return this;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        assert (this.operators.size() == this.operands.size() - 1);
        if (this.operands.size() == 1) {
            return this.operands.get(0).compile(context);
        }
        Expression left = this.operands.get(0).compile(context);
        for (int i = 1; i < this.operands.size(); ++i) {
            Expression right = this.operands.get(i).compile(context);
            Operator operator = this.operators.get(i - 1);
            try {
                left = BinaryOperator.fromOperator(operator).expression(this.position(), left, right);
                continue;
            }
            catch (OperationNotFoundException e) {
                throw new CompileException(this.position() + ": " + e.getMessage());
            }
        }
        return left;
    }

    public void transformFirst(Function<CompilableExpression, CompilableExpression> transformation) {
        this.operands.set(0, (CompilableExpression)transformation.apply((Object)this.operands.get(0)));
    }
}

