/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.util.BooleanOperations;

public class OperationTernary
extends AbstractCompilableExpression {
    private final CompilableExpression condition;
    private CompilableExpression ifTrueExpression;
    private CompilableExpression ifFalseExpression;

    public OperationTernary(JtwigPosition position, CompilableExpression booleanExpression) {
        super(position);
        this.condition = booleanExpression;
    }

    public OperationTernary withTrueExpression(CompilableExpression ifTrueExpression) {
        this.ifTrueExpression = ifTrueExpression;
        return this;
    }

    public OperationTernary withFalseExpression(CompilableExpression ifFalseExpression) {
        this.ifFalseExpression = ifFalseExpression;
        return this;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        return new Compiled(this.condition.compile(context), this.ifTrueExpression.compile(context), this.ifFalseExpression.compile(context));
    }

    private static class Compiled
    implements Expression {
        private final Expression condition;
        private final Expression trueExpression;
        private final Expression falseExpression;

        private Compiled(Expression condition, Expression trueExpression, Expression falseExpression) {
            this.condition = condition;
            this.trueExpression = trueExpression;
            this.falseExpression = falseExpression;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            if (BooleanOperations.isTrue(this.condition.calculate(context))) {
                return this.trueExpression.calculate(context);
            }
            return this.falseExpression.calculate(context);
        }
    }
}

