/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.OperationNotFoundException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.api.UnaryOperation;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.expressions.model.Operator;
import com.lyncode.jtwig.expressions.operations.UnaryOperator;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;

public class OperationUnary
extends AbstractCompilableExpression {
    private final Operator operator;
    private CompilableExpression operand;

    public OperationUnary(JtwigPosition position, Operator operator, CompilableExpression operand) {
        super(position);
        this.operator = operator;
        this.operand = operand;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        try {
            return new Operation(this.operand.compile(context), UnaryOperator.fromOperator(this.operator).operation());
        }
        catch (OperationNotFoundException e) {
            throw new CompileException(e);
        }
    }

    private static class Operation
    implements Expression {
        private final Expression operand;
        private final UnaryOperation operation;

        private Operation(Expression operand, UnaryOperation operation) {
            this.operand = operand;
            this.operation = operation;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            return this.operation.apply(context, this.operand);
        }
    }

    public static class Builder
    implements CompilableExpression {
        private JtwigPosition position;
        private Operator operator;
        private CompilableExpression operand;

        public Builder withPosition(JtwigPosition position) {
            this.position = position;
            return this;
        }

        public Builder withOperator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public Builder withOperand(CompilableExpression operand) {
            this.operand = operand;
            return this;
        }

        public OperationUnary build() {
            return new OperationUnary(this.position, this.operator, this.operand);
        }

        @Override
        public Expression compile(CompileContext context) throws CompileException {
            return null;
        }
    }
}

