/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.expressions.model.Constant;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import java.util.ArrayList;
import java.util.List;

public class ValueList
extends AbstractCompilableExpression {
    private final List<CompilableExpression> values = new ArrayList<CompilableExpression>();

    public static ValueList create(JtwigPosition position, Constant init, Constant end) {
        ValueList valueList = new ValueList(position);
        if (init.isInstanceOf(Integer.class)) {
            int endValue;
            if (!end.isInstanceOf(Integer.class)) {
                throw new ParseBypassException(new ParseException(position + ": Expected an integer for the end of the comprehension list"));
            }
            int initValue = init.as(Integer.class);
            if (initValue < (endValue = end.as(Integer.class).intValue())) {
                for (int i = initValue; i <= endValue; ++i) {
                    valueList.add(new Constant<Integer>(i));
                }
            } else {
                for (int i = initValue; i >= endValue; --i) {
                    valueList.add(new Constant<Integer>(i));
                }
            }
        } else if (init.isInstanceOf(Character.class)) {
            char endValue;
            if (!end.isInstanceOf(Character.class)) {
                throw new ParseBypassException(new ParseException(position + ": Expected a character for the end of the comprehension list"));
            }
            char initValue = init.as(Character.class).charValue();
            if (initValue < (endValue = end.as(Character.class).charValue())) {
                for (char i = initValue; i <= endValue; i = (char)(i + '\u0001')) {
                    valueList.add(new Constant<Character>(Character.valueOf(i)));
                }
            } else {
                for (char i = initValue; i >= endValue; i = (char)(i - '\u0001')) {
                    valueList.add(new Constant<Character>(Character.valueOf(i)));
                }
            }
        } else {
            throw new ParseBypassException(new ParseException(position + ": Only integers and characters are allowed in comprehension lists"));
        }
        return valueList;
    }

    public ValueList(JtwigPosition position) {
        super(position);
    }

    public ValueList add(CompilableExpression element) {
        this.values.add(element);
        return this;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (CompilableExpression value : this.values) {
            expressions.add(value.compile(context));
        }
        return new Compiled(expressions);
    }

    private static class Compiled
    implements Expression {
        private final List<Expression> expressions;

        private Compiled(List<Expression> expressions) {
            this.expressions = expressions;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Expression obj : this.expressions) {
                result.add(obj.calculate(context));
            }
            return result;
        }
    }
}

