/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValueMap
extends AbstractCompilableExpression {
    private Map<String, CompilableExpression> map = new LinkedHashMap<String, CompilableExpression>();

    public ValueMap(JtwigPosition position) {
        super(position);
    }

    public ValueMap add(String key, CompilableExpression element) {
        this.map.put(key, element);
        return this;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        LinkedHashMap<String, Expression> result = new LinkedHashMap<String, Expression>();
        for (Map.Entry<String, CompilableExpression> entry : this.map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().compile(context));
        }
        return new Compiled(result);
    }

    private static class Compiled
    implements Expression {
        private final Map<String, Expression> expressions;

        private Compiled(Map<String, Expression> expressions) {
            this.expressions = expressions;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Expression> entry : this.expressions.entrySet()) {
                result.put(entry.getKey(), entry.getValue().calculate(context));
            }
            return result;
        }
    }
}

