/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.expressions.model.FunctionElement;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.types.Undefined;
import com.lyncode.jtwig.util.ObjectExtractor;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variable
extends AbstractCompilableExpression {
    private static Logger log = LoggerFactory.getLogger(Variable.class);
    private String name;

    public Variable(JtwigPosition position, String name) {
        super(position);
        this.name = name;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        return new Compiled(this.position(), this.name);
    }

    public CompilableExpression toFunction() {
        return new FunctionElement(this.position(), this.name);
    }

    public static class Compiled
    implements Expression {
        private final String name;
        private final JtwigPosition position;

        public Compiled(JtwigPosition position, String name) {
            this.position = position;
            this.name = name;
        }

        public FunctionElement.Compiled toFunction() {
            return new FunctionElement.Compiled(this.position, this.name, new ArrayList<Expression>());
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            Object result = context.map(this.name);
            if (result instanceof Undefined) {
                if (context.configuration().strictMode()) {
                    throw new CalculateException(this.position + String.format(": Variable '%s' does not exist", this.name));
                }
                if (context.configuration().logNonStrictMode()) {
                    log.debug(this.position + String.format(": Variable '%s' does not exist", this.name));
                }
            }
            return result;
        }

        public Object extract(ObjectExtractor extractor) throws ObjectExtractor.ExtractException {
            return extractor.extract(this.name, new Object[0]);
        }

        public String name() {
            return this.name;
        }
    }
}

