/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.operations;

import com.google.common.base.Function;
import com.lyncode.jtwig.exception.OperationNotFoundException;
import com.lyncode.jtwig.expressions.api.BinaryExpressionFactory;
import com.lyncode.jtwig.expressions.model.Operator;
import com.lyncode.jtwig.expressions.operations.binary.AndOperation;
import com.lyncode.jtwig.expressions.operations.binary.DiffOperation;
import com.lyncode.jtwig.expressions.operations.binary.DivOperation;
import com.lyncode.jtwig.expressions.operations.binary.EndsWithOperation;
import com.lyncode.jtwig.expressions.operations.binary.EqualOperation;
import com.lyncode.jtwig.expressions.operations.binary.GreaterOrEqualThanOperation;
import com.lyncode.jtwig.expressions.operations.binary.GreaterThanOperation;
import com.lyncode.jtwig.expressions.operations.binary.InOperation;
import com.lyncode.jtwig.expressions.operations.binary.IntDivOperation;
import com.lyncode.jtwig.expressions.operations.binary.IntMultOperation;
import com.lyncode.jtwig.expressions.operations.binary.LessOrEqualThanOperation;
import com.lyncode.jtwig.expressions.operations.binary.LessThanOperation;
import com.lyncode.jtwig.expressions.operations.binary.MatchesOperation;
import com.lyncode.jtwig.expressions.operations.binary.ModOperation;
import com.lyncode.jtwig.expressions.operations.binary.MultOperation;
import com.lyncode.jtwig.expressions.operations.binary.NotInOperation;
import com.lyncode.jtwig.expressions.operations.binary.OrOperation;
import com.lyncode.jtwig.expressions.operations.binary.SelectionOperation;
import com.lyncode.jtwig.expressions.operations.binary.StartsWithOperation;
import com.lyncode.jtwig.expressions.operations.binary.SubOperation;
import com.lyncode.jtwig.expressions.operations.binary.SumOperation;
import com.lyncode.jtwig.expressions.operations.factories.CompositionExpressionFactory;
import com.lyncode.jtwig.expressions.operations.factories.ConstantExpressionFactory;
import com.lyncode.jtwig.expressions.operations.factories.TransformationExpressionFactory;
import com.lyncode.jtwig.util.BooleanOperations;

public enum BinaryOperator {
    COMPOSITION(Operator.COMPOSITION, new CompositionExpressionFactory()),
    SELECTION(Operator.SELECTION, ConstantExpressionFactory.operation(new SelectionOperation())),
    SUM(Operator.ADD, ConstantExpressionFactory.operation(new SumOperation())),
    SUB(Operator.SUB, ConstantExpressionFactory.operation(new SubOperation())),
    MOD(Operator.MOD, ConstantExpressionFactory.operation(new ModOperation())),
    MUL(Operator.TIMES, ConstantExpressionFactory.operation(new MultOperation())),
    INT_MUL(Operator.INT_TIMES, ConstantExpressionFactory.operation(new IntMultOperation())),
    DIV(Operator.DIV, ConstantExpressionFactory.operation(new DivOperation())),
    INT_DIV(Operator.INT_DIV, ConstantExpressionFactory.operation(new IntDivOperation())),
    AND(Operator.AND, ConstantExpressionFactory.operation(new AndOperation())),
    OR(Operator.OR, ConstantExpressionFactory.operation(new OrOperation())),
    GT(Operator.GT, ConstantExpressionFactory.operation(new GreaterThanOperation())),
    GTE(Operator.GTE, ConstantExpressionFactory.operation(new GreaterOrEqualThanOperation())),
    LT(Operator.LT, ConstantExpressionFactory.operation(new LessThanOperation())),
    LTE(Operator.LTE, ConstantExpressionFactory.operation(new LessOrEqualThanOperation())),
    EQUAL(Operator.EQUAL, ConstantExpressionFactory.operation(new EqualOperation())),
    DIFF(Operator.DIFF, ConstantExpressionFactory.operation(new DiffOperation())),
    IN(Operator.IN, ConstantExpressionFactory.operation(new InOperation())),
    NOT_IN(Operator.NOT_IN, ConstantExpressionFactory.operation(new NotInOperation())),
    MATCHES(Operator.MATCHES, ConstantExpressionFactory.operation(new MatchesOperation())),
    ENDS_WITH(Operator.ENDS_WITH, ConstantExpressionFactory.operation(new EndsWithOperation())),
    STARTS_WITH(Operator.STARTS_WITH, ConstantExpressionFactory.operation(new StartsWithOperation())),
    IS(Operator.IS, new TransformationExpressionFactory(new CompositionExpressionFactory(), BinaryOperator.isTrueFunction())),
    IS_NOT(Operator.IS_NOT, new TransformationExpressionFactory(new CompositionExpressionFactory(), BinaryOperator.notIsTrueFunction()));

    private Operator operator;
    private BinaryExpressionFactory expression;

    public static BinaryExpressionFactory fromOperator(Operator operator) throws OperationNotFoundException {
        for (BinaryOperator binaryOperator : BinaryOperator.values()) {
            if (binaryOperator.operator != operator) continue;
            return binaryOperator.expression;
        }
        throw new OperationNotFoundException(" Unable to find implementation for operator " + (Object)((Object)operator));
    }

    private BinaryOperator(Operator operator, BinaryExpressionFactory expression) {
        this.operator = operator;
        this.expression = expression;
    }

    private static Function<Object, Object> notIsTrueFunction() {
        return new Function<Object, Object>(){

            public Object apply(Object input) {
                return !BooleanOperations.isTrue(input);
            }
        };
    }

    private static Function<Object, Object> isTrueFunction() {
        return new Function<Object, Object>(){

            public Object apply(Object input) {
                return BooleanOperations.isTrue(input);
            }
        };
    }
}

