/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.operations;

import com.lyncode.jtwig.exception.OperationNotFoundException;
import com.lyncode.jtwig.expressions.api.UnaryOperation;
import com.lyncode.jtwig.expressions.model.Operator;
import com.lyncode.jtwig.expressions.operations.unary.NegativeOperation;
import com.lyncode.jtwig.expressions.operations.unary.NotOperation;

public enum UnaryOperator {
    NOT(Operator.NOT, new NotOperation()),
    NEGATIVE(Operator.SUB, new NegativeOperation());

    private final Operator operator;
    private final UnaryOperation operation;

    public static UnaryOperator fromOperator(Operator operator) throws OperationNotFoundException {
        for (UnaryOperator unary : UnaryOperator.values()) {
            if (unary.operator != operator) continue;
            return unary;
        }
        throw new OperationNotFoundException("Unable to find operator " + (Object)((Object)operator));
    }

    private UnaryOperator(Operator operator, UnaryOperation operation) {
        this.operator = operator;
        this.operation = operation;
    }

    public UnaryOperation operation() {
        return this.operation;
    }
}

