/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.operations.binary;

import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.expressions.api.BinaryOperation;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.FunctionElement;
import com.lyncode.jtwig.expressions.model.Variable;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.types.Undefined;
import com.lyncode.jtwig.util.ObjectExtractor;

public class SelectionOperation
implements BinaryOperation {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(RenderContext context, JtwigPosition position, Expression left, Expression right) throws CalculateException {
        Object calculate = left.calculate(context);
        if (calculate == null) {
            if (!context.configuration().strictMode()) return Undefined.UNDEFINED;
            if (right instanceof Variable.Compiled) {
                String propertyName = ((Variable.Compiled)right).name();
                throw new CalculateException(String.format(position + ": Impossible to access attribute/method '%s' on null", propertyName));
            }
            if (right instanceof FunctionElement.Compiled) {
                String propertyName = ((FunctionElement.Compiled)right).name();
                throw new CalculateException(String.format(position + ": Impossible to access attribute/method '%s' on null", propertyName));
            }
        } else if (calculate == Undefined.UNDEFINED) {
            if (!context.configuration().strictMode()) return Undefined.UNDEFINED;
            if (right instanceof Variable.Compiled) {
                String propertyName = ((Variable.Compiled)right).name();
                throw new CalculateException(String.format(position + ": Impossible to access attribute/method '%s' on undefined", propertyName));
            }
            if (right instanceof FunctionElement.Compiled) {
                String propertyName = ((FunctionElement.Compiled)right).name();
                throw new CalculateException(String.format(position + ": Impossible to access attribute/method '%s' on undefined", propertyName));
            }
        }
        ObjectExtractor extractor = new ObjectExtractor(calculate);
        try {
            if (right instanceof Variable.Compiled) {
                return ((Variable.Compiled)right).extract(extractor);
            }
            if (!(right instanceof FunctionElement.Compiled)) throw new CalculateException("Selection operator must be given a variable/function as right argument");
            return ((FunctionElement.Compiled)right).extract(context, extractor);
        }
        catch (ObjectExtractor.ExtractException e) {
            throw new CalculateException(e);
        }
    }
}

