/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.operations.factories;

import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.BinaryExpressionFactory;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.FunctionElement;
import com.lyncode.jtwig.expressions.model.Variable;
import com.lyncode.jtwig.parser.model.JtwigPosition;

public class CompositionExpressionFactory
implements BinaryExpressionFactory {
    @Override
    public Expression expression(JtwigPosition position, Expression left, Expression right) throws CompileException {
        if (right instanceof Variable.Compiled) {
            return this.function(((Variable.Compiled)right).toFunction(), left);
        }
        if (right instanceof FunctionElement.Compiled) {
            return this.function((FunctionElement.Compiled)right, left);
        }
        throw new CompileException(position + ": Composition always requires a function to execute as the right argument");
    }

    private Expression function(FunctionElement.Compiled compiled, Expression left) {
        return compiled.cloneAndAddArgument(left);
    }
}

