/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Compilable;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.parser.config.ParserConfiguration;
import com.lyncode.jtwig.parser.parboiled.JtwigContentParser;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.resource.JtwigResource;
import java.io.IOException;

public class JtwigParser {
    private final ParserConfiguration configuration;

    public JtwigParser(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public Compilable parse(JtwigResource resource) throws ParseException {
        JtwigContentParser parser = JtwigContentParser.newParser(resource, this.configuration);
        return new Document(JtwigContentParser.parse(parser, resource));
    }

    private static class CompiledDocument
    implements Renderable {
        private final Renderable renderable;

        private CompiledDocument(Renderable renderable) {
            this.renderable = renderable;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            try {
                this.renderable.render(context);
                context.renderStream().waitForExecutorCompletion();
                context.renderStream().close();
                context.renderStream().merge();
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
        }
    }

    private static class Document
    implements Compilable {
        private final Compilable content;

        private Document(Compilable content) {
            this.content = content;
        }

        @Override
        public Renderable compile(CompileContext context) throws CompileException {
            return new CompiledDocument(this.content.compile(context));
        }
    }
}

