/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser.parboiled;

import com.lyncode.jtwig.parser.config.ParserConfiguration;
import com.lyncode.jtwig.parser.model.JtwigKeyword;
import com.lyncode.jtwig.parser.model.JtwigSymbol;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.annotations.SuppressNode;

public class JtwigBasicParser
extends BaseParser<String> {
    final ParserConfiguration parserConfiguration;
    StringBuilder stringBuilder;

    public JtwigBasicParser(ParserConfiguration parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
    }

    @SuppressNode
    public Rule spacing() {
        return this.ZeroOrMore(this.FirstOf(this.OneOrMore(this.AnyOf(" \t\r\n\f").label("Whitespace")), this.Sequence(this.openComment(), this.ZeroOrMore(this.TestNot(this.closeComment()), ANY, new Object[0]), new Object[]{this.closeComment()}).label("Comment"), new Object[0]));
    }

    public Rule closeCode() {
        return this.String(this.parserConfiguration.symbols().endTag());
    }

    public Rule openCode() {
        return this.String(this.parserConfiguration.symbols().beginTag());
    }

    public Rule openOutput() {
        return this.String(this.parserConfiguration.symbols().beginOutput());
    }

    public Rule closeOutput() {
        return this.String(this.parserConfiguration.symbols().endOutput());
    }

    public Rule openComment() {
        return this.String(this.parserConfiguration.symbols().beginComment());
    }

    public Rule closeComment() {
        return this.String(this.parserConfiguration.symbols().endComment());
    }

    @MemoMismatches
    public Rule anyKeyword() {
        return this.Sequence(this.FirstOf(JtwigKeyword.keywords()), this.TestNot(this.letterOrDigit()), new Object[0]);
    }

    public Rule identifier() {
        return this.Sequence(this.TestNot(this.anyKeyword()), this.letter(), new Object[]{this.ZeroOrMore(this.letterOrDigit())});
    }

    @SuppressNode
    public Rule keyword(JtwigKeyword keyword) {
        return this.terminal(keyword.getKeyword(), this.letterOrDigit());
    }

    @SuppressNode
    public Rule symbol(JtwigSymbol symbol) {
        return this.terminal(symbol.getSymbol());
    }

    @SuppressNode
    @DontLabel
    Rule terminal(String string, Rule mustNotFollow) {
        return this.Sequence(string, this.TestNot(mustNotFollow), new Object[0]).label('\'' + string + '\'');
    }

    @SuppressNode
    @DontLabel
    Rule terminal(String string) {
        return this.String(string).label('\'' + string + '\'');
    }

    public Rule onlyOneChar() {
        return this.Sequence(this.symbol(JtwigSymbol.QUOTE), this.character(), new Object[]{this.push(this.match()), this.symbol(JtwigSymbol.QUOTE)});
    }

    Rule character() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[0]);
    }

    Rule letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    @MemoMismatches
    Rule letterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_'), Character.valueOf('$')});
    }

    protected Rule stringLiteral() {
        return this.FirstOf(this.Sequence(Character.valueOf('\"'), this.startBuilder(), new Object[]{this.ZeroOrMore(this.FirstOf(this.escape("\""), this.Sequence(this.Sequence(this.TestNot(this.AnyOf("\r\n\"\\")), ANY, new Object[0]), this.append(this.match()), new Object[0]), new Object[0])).suppressSubnodes(), this.push(this.stringBuilder.toString()), Character.valueOf('\"')}), this.Sequence("'", this.startBuilder(), new Object[]{this.ZeroOrMore(this.FirstOf(this.escape("'"), this.Sequence(this.Sequence(this.TestNot(this.AnyOf("\r\n'\\")), ANY, new Object[0]), this.append(this.match()), new Object[0]), new Object[0])).suppressSubnodes(), this.push(this.stringBuilder.toString()), "'"}), new Object[0]);
    }

    boolean startBuilder() {
        this.stringBuilder = new StringBuilder();
        return true;
    }

    boolean append(String text) {
        this.stringBuilder.append(text);
        return true;
    }

    Rule escape(String value) {
        return this.FirstOf(this.Sequence(this.toRule(Character.valueOf('\\')), value, new Object[]{this.append(this.match())}), this.Sequence(this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("btnfr\"'\\"), this.octalEscape(), new Object[]{this.unicodeEscape()}), new Object[0]), this.append(this.match()), new Object[0]), new Object[0]);
    }

    Rule escape() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("btnfr\"'\\"), this.octalEscape(), new Object[]{this.unicodeEscape()}), new Object[0]);
    }

    Rule octalEscape() {
        return this.FirstOf(this.Sequence(this.CharRange('0', '3'), this.CharRange('0', '7'), new Object[]{this.CharRange('0', '7')}), this.Sequence(this.CharRange('0', '7'), this.CharRange('0', '7'), new Object[0]), new Object[]{this.CharRange('0', '7')});
    }

    Rule unicodeEscape() {
        return this.Sequence(this.OneOrMore(Character.valueOf('u')), this.hexDigit(), new Object[]{this.hexDigit(), this.hexDigit(), this.hexDigit()});
    }

    Rule hexDigit() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.CharRange('0', '9')});
    }

    Rule digit() {
        return this.CharRange('0', '9');
    }
}

