/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser.parboiled;

import com.lyncode.jtwig.expressions.model.Constant;
import com.lyncode.jtwig.parser.config.ParserConfiguration;
import com.lyncode.jtwig.parser.model.JtwigKeyword;
import com.lyncode.jtwig.parser.model.JtwigSymbol;
import com.lyncode.jtwig.parser.parboiled.JtwigBasicParser;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;

public class JtwigConstantParser
extends BaseParser<Constant> {
    final JtwigBasicParser basic;

    public JtwigConstantParser(ParserConfiguration parserConfiguration) {
        this.basic = (JtwigBasicParser)Parboiled.createParser(JtwigBasicParser.class, (Object[])new Object[]{parserConfiguration});
    }

    public JtwigConstantParser() {
        this(new ParserConfiguration());
    }

    public Rule anyConstant() {
        return this.FirstOf(this.nullValue(), this.booleanValue(), new Object[]{this.doubleValue(), this.integerValue(), this.charValue(), this.string()});
    }

    public Rule booleanValue() {
        return this.FirstOf(this.Sequence(this.basic.keyword(JtwigKeyword.TRUE), this.push(new Constant<Boolean>(true)), new Object[0]), this.Sequence(this.basic.keyword(JtwigKeyword.FALSE), this.push(new Constant<Boolean>(false)), new Object[0]), new Object[0]);
    }

    public Rule nullValue() {
        return this.Sequence(this.basic.keyword(JtwigKeyword.NULL), this.push(new Constant<Object>(null)), new Object[0]);
    }

    public Rule charValue() {
        return this.Sequence(this.basic.onlyOneChar(), this.push(new Constant<Character>(Character.valueOf(((String)this.basic.pop()).charAt(0)))), new Object[0]);
    }

    public Rule integerValue() {
        return this.Sequence(this.OneOrMore(this.basic.digit()), this.push(new Constant<Integer>(Integer.parseInt(this.match()))), new Object[0]);
    }

    public Rule doubleValue() {
        return this.Sequence(this.Sequence(this.OneOrMore(this.basic.digit()), this.basic.symbol(JtwigSymbol.DOT), new Object[]{this.OneOrMore(this.basic.digit())}), this.push(new Constant<Double>(Double.valueOf(this.match()))), new Object[0]);
    }

    public Rule string() {
        return this.Sequence(this.basic.stringLiteral(), this.push(new Constant<Object>(this.basic.pop())), new Object[0]);
    }
}

