/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser.parboiled;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.lyncode.jtwig.addons.Addon;
import com.lyncode.jtwig.addons.AddonModel;
import com.lyncode.jtwig.content.api.Compilable;
import com.lyncode.jtwig.content.api.Tag;
import com.lyncode.jtwig.content.model.compilable.Block;
import com.lyncode.jtwig.content.model.compilable.Comment;
import com.lyncode.jtwig.content.model.compilable.Content;
import com.lyncode.jtwig.content.model.compilable.Extends;
import com.lyncode.jtwig.content.model.compilable.For;
import com.lyncode.jtwig.content.model.compilable.IfControl;
import com.lyncode.jtwig.content.model.compilable.Include;
import com.lyncode.jtwig.content.model.compilable.Output;
import com.lyncode.jtwig.content.model.compilable.Sequence;
import com.lyncode.jtwig.content.model.compilable.SetVariable;
import com.lyncode.jtwig.content.model.compilable.Text;
import com.lyncode.jtwig.content.model.compilable.Verbatim;
import com.lyncode.jtwig.content.model.tag.WhiteSpaceControl;
import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.model.Constant;
import com.lyncode.jtwig.parser.config.ParserConfiguration;
import com.lyncode.jtwig.parser.model.JtwigKeyword;
import com.lyncode.jtwig.parser.model.JtwigSymbol;
import com.lyncode.jtwig.parser.model.JtwigTagProperty;
import com.lyncode.jtwig.parser.parboiled.JtwigBaseParser;
import com.lyncode.jtwig.parser.parboiled.JtwigBasicParser;
import com.lyncode.jtwig.parser.parboiled.JtwigExpressionParser;
import com.lyncode.jtwig.parser.parboiled.JtwigTagPropertyParser;
import com.lyncode.jtwig.resource.JtwigResource;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.common.FileUtils;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

public class JtwigContentParser
extends JtwigBaseParser<Compilable> {
    final JtwigBasicParser basicParser;
    final JtwigExpressionParser expressionParser;
    final JtwigTagPropertyParser tagPropertyParser;
    Addon[] contentAddonParsers;
    Collection<Class<? extends BaseParser>> contentAddons;
    ParserConfiguration configuration;

    public static JtwigContentParser newParser(JtwigResource resource, ParserConfiguration configuration) {
        return (JtwigContentParser)Parboiled.createParser(JtwigContentParser.class, (Object[])new Object[]{resource, configuration});
    }

    public static Compilable parse(JtwigContentParser parser, JtwigResource input) throws ParseException {
        try {
            ReportingParseRunner runner = new ReportingParseRunner(parser.start());
            ParsingResult result = runner.run(FileUtils.readAllText((InputStream)input.retrieve(), (Charset)Charset.defaultCharset()));
            return (Compilable)result.resultValue;
        }
        catch (ParserRuntimeException e) {
            if (e.getCause() instanceof ParseBypassException) {
                ParseException innerException = ((ParseBypassException)e.getCause()).getInnerException();
                innerException.setExpression(e.getMessage());
                throw innerException;
            }
            throw new ParseException(e);
        }
        catch (ResourceException e) {
            throw new ParseException(e);
        }
    }

    public JtwigContentParser(JtwigResource resource, ParserConfiguration configuration) {
        super(resource);
        this.basicParser = (JtwigBasicParser)Parboiled.createParser(JtwigBasicParser.class, (Object[])new Object[]{configuration});
        this.tagPropertyParser = (JtwigTagPropertyParser)Parboiled.createParser(JtwigTagPropertyParser.class, (Object[])new Object[]{configuration});
        this.expressionParser = (JtwigExpressionParser)Parboiled.createParser(JtwigExpressionParser.class, (Object[])new Object[]{resource, configuration});
        this.contentAddons = Collections2.transform(configuration.addons().list(), this.toBaseParser());
        this.configuration = configuration;
        this.contentAddonParsers = new Addon[this.contentAddons.size()];
        int i = 0;
        for (Class<? extends BaseParser> contentAddon : this.contentAddons) {
            this.contentAddonParsers[i++] = (Addon)Parboiled.createParser(contentAddon, (Object[])new Object[]{resource, configuration});
        }
    }

    private Function<Class<? extends Addon>, Class<? extends BaseParser>> toBaseParser() {
        return new Function<Class<? extends Addon>, Class<? extends BaseParser>>(){

            @Nullable
            public Class<? extends BaseParser> apply(@Nullable Class<? extends Addon> input) {
                return input;
            }
        };
    }

    public Rule start() {
        return this.FirstOf(this.extendTemplate(), this.normalTemplate(), new Object[0]);
    }

    Rule extendTemplate() {
        return this.Sequence(this.basicParser.spacing(), this.Sequence(this.basicParser.openCode(), this.basicParser.spacing(), new Object[]{this.keyword(JtwigKeyword.EXTENDS), this.mandatory(this.Sequence(this.expressionParser.expression(), this.push(new Extends((CompilableExpression)this.expressionParser.pop())), new Object[]{this.basicParser.spacing(), this.basicParser.closeCode(), this.ZeroOrMore(this.basicParser.spacing(), this.block(), new Object[]{this.action(this.peek(1, Extends.class).add(this.pop(Block.class)))}), this.basicParser.spacing(), EOI}), new ParseException("Wrong extends syntax"))}), new Object[0]);
    }

    Rule normalTemplate() {
        return this.Sequence(this.content(), EOI, new Object[0]);
    }

    Rule content() {
        return this.Sequence(this.push(new Sequence()), this.ZeroOrMore(this.FirstOf(this.addToContent(this.output()), this.addToContent(this.block()), new Object[]{this.addToContent(this.include()), this.addToContent(this.embed()), this.addToContent(this.forEach()), this.addToContent(this.ifCondition()), this.addToContent(this.set()), this.addToContent(this.verbatim()), this.addToContent(this.comment()), this.addToContent(this.contentParsers()), this.Sequence(this.openCode(), this.TestNot(this.FirstOf(this.keyword(JtwigKeyword.ENDBLOCK), this.keyword(JtwigKeyword.ENDFOR), new Object[]{this.keyword(JtwigKeyword.ENDIF), this.keyword(JtwigKeyword.IF), this.keyword(JtwigKeyword.BLOCK), this.keyword(JtwigKeyword.FOR), this.keyword(JtwigKeyword.SET), this.keyword(JtwigKeyword.ELSEIF), this.keyword(JtwigKeyword.ELSE), this.keyword(JtwigKeyword.VERBATIM), this.keyword(JtwigKeyword.ENDFILTER), this.keywordsContent()})), new Object[]{this.throwException(new ParseException("Unknown tag"))}), this.addToContent(this.text())})), new Object[0]);
    }

    Rule keywordsContent() {
        if (this.contentAddonParsers.length == 0) {
            return this.Test(false);
        }
        Object[] rules = new Rule[this.contentAddonParsers.length];
        for (int i = 0; i < this.contentAddonParsers.length; ++i) {
            rules[i] = this.FirstOf(this.basicParser.terminal(this.contentAddonParsers[i].beginKeyword()), this.basicParser.terminal(this.contentAddonParsers[i].endKeyword()), new Object[0]);
        }
        return this.FirstOf(rules);
    }

    Rule contentParsers() {
        if (this.contentAddonParsers.length == 0) {
            return this.Test(false);
        }
        Object[] rules = new Rule[this.contentAddonParsers.length];
        for (int i = 0; i < this.contentAddonParsers.length; ++i) {
            rules[i] = this.contentAddon(this.contentAddonParsers[i]);
        }
        return this.FirstOf(rules);
    }

    Rule contentAddon(Addon parser) {
        return this.Sequence(this.openCode(), this.basicParser.terminal(parser.beginKeyword()), new Object[]{this.basicParser.spacing(), parser.startRule(), this.mandatory(this.Test(CoreMatchers.instanceOf(AddonModel.class).matches(this.peek())), new ParseException("Addon parser not pushing a JtwigContentAddon object to the top of the stack")), this.mandatory(this.Sequence(this.action(this.beforeBeginTrim()), this.closeCode(), new Object[]{this.action(this.afterBeginTrim()), this.content(), this.action(this.peek(1, AddonModel.class).withContent(this.pop(Sequence.class))), this.openCode(), this.basicParser.terminal(parser.endKeyword()), this.basicParser.spacing(), this.action(this.beforeEndTrim()), this.closeCode(), this.action(this.afterEndTrim())}), new ParseException("Wrong syntax for " + parser.beginKeyword()))});
    }

    Rule addToContent(Rule innerRule) {
        return this.Sequence(innerRule, this.action(this.peek(1, Sequence.class).add((Compilable)this.pop())), new Object[0]);
    }

    Rule block() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.BLOCK), new Object[]{this.mandatory(this.Sequence(this.expressionParser.identifierAsString(), this.push(new Block(this.expressionParser.popIdentifierAsString())), new Object[]{this.action(this.beforeBeginTrim()), this.closeCode(), this.action(this.afterBeginTrim()), this.content(), this.action(this.peek(1, Block.class).withContent(this.pop(Sequence.class))), this.openCode(), this.action(this.beforeEndTrim()), this.keyword(JtwigKeyword.ENDBLOCK), this.Optional(this.expressionParser.variable(), this.assertEqual(this.peek(Block.class).name(), (String)this.expressionParser.pop(Constant.class).getValue()), new Object[0]), this.closeCode(), this.action(this.afterEndTrim())}), new ParseException("Wrong block syntax"))});
    }

    boolean assertEqual(String value1, String value2) {
        if (!value1.equals(value2)) {
            return this.throwException(new ParseException("Start statement and ending block names do not match"));
        }
        return true;
    }

    Rule include() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.INCLUDE), new Object[]{this.mandatory(this.Sequence(this.basicParser.stringLiteral(), this.basicParser.spacing(), new Object[]{this.push(new Include(this.currentPosition(), (String)this.basicParser.pop())), this.action(this.beforeBeginTrim()), this.Optional(this.keyword(JtwigKeyword.IGNORE_MISSING), this.action(this.peek(Include.class).setIgnoreMissing(true)), new Object[0]), this.Optional(this.keyword(JtwigKeyword.WITH), this.FirstOf(this.expressionParser.map(), this.expressionParser.variable(), new Object[0]), new Object[]{this.action(this.peek(1, Include.class).with((CompilableExpression)this.expressionParser.pop()))}), this.Optional(this.keyword(JtwigKeyword.ONLY), this.action(this.peek(Include.class).setIsolated(true)), new Object[0]), this.closeCode(), this.action(this.afterEndTrim())}), new ParseException("Wrong include syntax"))});
    }

    Rule embed() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.EMBED), new Object[]{this.mandatory(this.Sequence(this.basicParser.stringLiteral(), this.basicParser.spacing(), new Object[]{this.closeCode(), this.push(new Extends((String)this.basicParser.pop())), this.ZeroOrMore(this.basicParser.spacing(), this.block(), new Object[]{this.action(this.peek(1, Extends.class).add(this.pop(Block.class)))}), this.basicParser.spacing(), this.openCode(), this.keyword(JtwigKeyword.ENDEMBED), this.closeCode()}), new ParseException("Wrong embed syntax"))});
    }

    Rule text() {
        return this.Sequence(this.push(new Text.Builder()), this.OneOrMore(this.FirstOf(this.Sequence(this.basicParser.escape(), this.action(this.peek(Text.Builder.class).append(this.match())), new Object[0]), this.Sequence(this.TestNot(this.FirstOf(this.basicParser.openCode(), this.basicParser.openOutput(), new Object[]{this.basicParser.openComment()})), ANY, new Object[]{this.action(this.peek(Text.Builder.class).append(this.match()))}), new Object[0])).suppressSubnodes(), new Object[]{this.push(this.pop(Text.Builder.class).build())});
    }

    Rule verbatim() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.VERBATIM), new Object[]{this.mandatory(this.Sequence(this.push(new Verbatim()), this.action(this.beforeBeginTrim()), new Object[]{this.closeCode(), this.text(this.Sequence(this.basicParser.openCode(), this.basicParser.spacing(), new Object[]{this.keyword(JtwigKeyword.ENDVERBATIM)})), this.action(this.peek(1, Verbatim.class).withContent(new Sequence().add(this.pop(Compilable.class)))), this.openCode(), this.keyword(JtwigKeyword.ENDVERBATIM), this.closeCode(), this.action(this.afterEndTrim())}), new ParseException("Wrong verbatim syntax"))});
    }

    Rule text(Rule until) {
        return this.Sequence(this.push(new Text.Builder()), this.OneOrMore(this.FirstOf(this.Sequence(this.basicParser.escape(), this.action(this.peek(Text.Builder.class).append(this.match())), new Object[0]), this.Sequence(this.TestNot(until), ANY, new Object[]{this.action(this.peek(Text.Builder.class).append(this.match()))}), new Object[0])).suppressSubnodes(), new Object[]{this.push(this.pop(Text.Builder.class).build())});
    }

    Rule ifCondition() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.IF), new Object[]{this.mandatory(this.Sequence(this.push(new IfControl()), this.expressionParser.expression(), new Object[]{this.push(new IfControl.Case((CompilableExpression)this.expressionParser.pop())), this.action(this.beforeBeginTrim()), this.closeCode(), this.action(this.afterBeginTrim()), this.content(), this.action(this.peek(1, IfControl.Case.class).withContent(this.pop(Sequence.class))), this.ZeroOrMore(this.Sequence(this.action(this.peek(1, IfControl.class).add(this.peek(IfControl.Case.class))), this.openCode(), new Object[]{this.keyword(JtwigKeyword.ELSEIF), this.expressionParser.expression(), this.push(new IfControl.Case((CompilableExpression)this.expressionParser.pop())), this.action(this.beforeEndTrim(1)), this.action(this.beforeBeginTrim()), this.closeCode(), this.action(this.afterEndTrim(1)), this.action(this.afterBeginTrim()), this.action(this.pop(1)), this.content(), this.action(this.peek(1, IfControl.Case.class).withContent(this.pop(Sequence.class)))})), this.Optional(this.Sequence(this.action(this.peek(1, IfControl.class).add(this.peek(IfControl.Case.class))), this.openCode(), new Object[]{this.keyword(JtwigKeyword.ELSE), this.push(new IfControl.Case(new Constant<Boolean>(true))), this.action(this.beforeEndTrim(1)), this.action(this.beforeBeginTrim()), this.closeCode(), this.action(this.afterEndTrim(1)), this.action(this.afterBeginTrim()), this.action(this.pop(1)), this.content(), this.action(this.peek(1, IfControl.Case.class).withContent(this.pop(Sequence.class)))})), this.action(this.peek(1, IfControl.class).add(this.peek(IfControl.Case.class))), this.openCode(), this.action(this.beforeEndTrim()), this.keyword(JtwigKeyword.ENDIF), this.closeCode(), this.action(this.afterEndTrim()), this.action(this.pop())}), new ParseException("Wrong if syntax"))});
    }

    Rule forEach() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.FOR), new Object[]{this.mandatory(this.Sequence(this.expressionParser.identifierAsString(), this.FirstOf(this.Sequence(this.symbolWithSpacing(JtwigSymbol.COMMA), this.expressionParser.identifierAsString(), new Object[]{this.keyword(JtwigKeyword.IN), this.expressionParser.expression(), this.push(new For(this.expressionParser.popIdentifierAsString(2), this.expressionParser.popIdentifierAsString(1), (CompilableExpression)this.expressionParser.pop()))}), this.Sequence(this.keyword(JtwigKeyword.IN), this.expressionParser.expression(), new Object[]{this.push(new For(this.expressionParser.popIdentifierAsString(1), (CompilableExpression)this.expressionParser.pop()))}), new Object[0]), new Object[]{this.action(this.beforeBeginTrim()), this.closeCode(), this.action(this.afterBeginTrim()), this.content(), this.action(this.peek(1, Content.class).withContent(this.pop(Sequence.class))), this.Optional(this.Sequence(this.openCode(), this.action(this.beforeEndTrim()), new Object[]{this.keyword(JtwigKeyword.ELSE), this.closeCode(), this.action(this.afterBeginTrim()), this.content(), this.action(this.peek(1, For.class).withElse(this.pop(Sequence.class)))})), this.openCode(), this.action(this.beforeEndTrim()), this.keyword(JtwigKeyword.ENDFOR), this.closeCode(), this.action(this.afterEndTrim())}), new ParseException("Wrong for each syntax"))});
    }

    Rule set() {
        return this.Sequence(this.openCode(), this.keyword(JtwigKeyword.SET), new Object[]{this.mandatory(this.Sequence(this.expressionParser.identifierAsString(), this.symbolWithSpacing(JtwigSymbol.ATTR), new Object[]{this.expressionParser.expression(), this.push(new SetVariable(this.expressionParser.popIdentifierAsString(1), (CompilableExpression)this.expressionParser.pop())), this.action(this.beforeBeginTrim()), this.closeCode(), this.action(this.afterEndTrim())}), new ParseException("Wrong set syntax"))});
    }

    Rule output() {
        return this.Sequence(this.basicParser.openOutput(), this.tagPropertyParser.property(), new Object[]{this.basicParser.spacing(), this.mandatory(this.Sequence(this.expressionParser.expression(), this.push(new Output((CompilableExpression)this.expressionParser.pop())), new Object[]{this.action(this.beforeBeginTrim()), this.tagPropertyParser.property(), this.action(this.afterEndTrim()), this.basicParser.closeOutput()}), new ParseException("Wrong output syntax"))});
    }

    Rule symbolWithSpacing(JtwigSymbol symbol) {
        return this.Sequence(this.basicParser.symbol(symbol), this.basicParser.spacing(), new Object[0]);
    }

    Rule comment() {
        return this.Sequence(this.push(new Comment()), this.basicParser.openComment(), new Object[]{this.tagPropertyParser.property(), this.action(this.beforeBeginTrim()), this.ZeroOrMore(this.TestNot(this.Sequence(this.basicParser.symbol(JtwigSymbol.MINUS), this.basicParser.closeComment(), new Object[0])), this.TestNot(this.basicParser.closeComment()), new Object[]{ANY}), this.tagPropertyParser.property(), this.action(this.afterEndTrim()), this.basicParser.closeComment()});
    }

    Rule openCode() {
        return this.Sequence(this.basicParser.openCode(), this.tagPropertyParser.property(), new Object[]{this.basicParser.spacing()});
    }

    Rule closeCode() {
        return this.Sequence(this.tagPropertyParser.property(), this.basicParser.closeCode(), new Object[0]);
    }

    Rule keyword(JtwigKeyword keyword) {
        return this.Sequence(this.basicParser.keyword(keyword), this.basicParser.spacing(), new Object[0]);
    }

    WhiteSpaceControl afterEndTrim(int p) {
        return this.peek(p, Tag.class).tag().whiteSpaceControl().trimAfterEnd(this.tagPropertyParser.getCurrentProperty() == JtwigTagProperty.Trim);
    }

    WhiteSpaceControl beforeEndTrim(int p) {
        return this.peek(p, Tag.class).tag().whiteSpaceControl().trimBeforeEnd(this.tagPropertyParser.getCurrentProperty() == JtwigTagProperty.Trim);
    }

    WhiteSpaceControl afterBeginTrim(int p) {
        return this.peek(p, Tag.class).tag().whiteSpaceControl().trimAfterBegin(this.tagPropertyParser.getCurrentProperty() == JtwigTagProperty.Trim);
    }

    WhiteSpaceControl beforeBeginTrim(int p) {
        return this.peek(p, Tag.class).tag().whiteSpaceControl().trimBeforeBegin(this.tagPropertyParser.getCurrentProperty() == JtwigTagProperty.Trim);
    }

    WhiteSpaceControl afterEndTrim() {
        return this.afterEndTrim(0);
    }

    WhiteSpaceControl beforeEndTrim() {
        return this.beforeEndTrim(0);
    }

    WhiteSpaceControl afterBeginTrim() {
        return this.afterBeginTrim(0);
    }

    WhiteSpaceControl beforeBeginTrim() {
        return this.beforeBeginTrim(0);
    }
}

