/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser.parboiled;

import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.model.BlockFunction;
import com.lyncode.jtwig.expressions.model.Constant;
import com.lyncode.jtwig.expressions.model.FunctionElement;
import com.lyncode.jtwig.expressions.model.MapSelection;
import com.lyncode.jtwig.expressions.model.OperationBinary;
import com.lyncode.jtwig.expressions.model.OperationTernary;
import com.lyncode.jtwig.expressions.model.OperationUnary;
import com.lyncode.jtwig.expressions.model.Operator;
import com.lyncode.jtwig.expressions.model.ValueList;
import com.lyncode.jtwig.expressions.model.ValueMap;
import com.lyncode.jtwig.expressions.model.Variable;
import com.lyncode.jtwig.parser.config.ParserConfiguration;
import com.lyncode.jtwig.parser.model.JtwigKeyword;
import com.lyncode.jtwig.parser.model.JtwigSymbol;
import com.lyncode.jtwig.parser.parboiled.JtwigBaseParser;
import com.lyncode.jtwig.parser.parboiled.JtwigBasicParser;
import com.lyncode.jtwig.parser.parboiled.JtwigConstantParser;
import com.lyncode.jtwig.resource.JtwigResource;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.SuppressNode;

public class JtwigExpressionParser
extends JtwigBaseParser<CompilableExpression> {
    final JtwigBasicParser basic;
    final JtwigConstantParser constants;
    final ParserConfiguration config;

    public JtwigExpressionParser(JtwigResource resource, ParserConfiguration parserConfiguration) {
        super(resource);
        this.basic = (JtwigBasicParser)Parboiled.createParser(JtwigBasicParser.class, (Object[])new Object[]{parserConfiguration});
        this.constants = (JtwigConstantParser)Parboiled.createParser(JtwigConstantParser.class, (Object[])new Object[]{parserConfiguration});
        this.config = parserConfiguration;
    }

    public Rule expression() {
        return this.Sequence(this.specificJtwigOperators(), this.push(this.pop()), new Object[0]);
    }

    Rule specificJtwigOperators() {
        return this.binary(this.orExpression(), Operator.STARTS_WITH, Operator.ENDS_WITH, Operator.MATCHES, Operator.IN, Operator.NOT_IN);
    }

    protected Rule orExpression() {
        return this.binary(this.andExpression(), Operator.OR);
    }

    Rule andExpression() {
        return this.binary(this.equalityExpression(), Operator.AND);
    }

    Rule equalityExpression() {
        return this.binary(this.relationalExpression(), Operator.EQUAL, Operator.DIFF);
    }

    Rule relationalExpression() {
        return this.binary(this.FirstOf(this.negation(), this.addition(), new Object[]{this.negative()}), Operator.LTE, Operator.GTE, Operator.LT, Operator.GT);
    }

    Rule negation() {
        return this.unary(this.addition(), Operator.NOT);
    }

    Rule negative() {
        return this.unary(this.addition(), Operator.SUB);
    }

    Rule addition() {
        return this.binary(this.multiplication(), Operator.ADD, Operator.SUB);
    }

    Rule multiplication() {
        return this.binary(this.composition(), Operator.INT_DIV, Operator.INT_TIMES, Operator.TIMES, Operator.DIV, Operator.MOD);
    }

    Rule composition() {
        return this.binary(this.isOperation(), this.FirstOf(this.functionWithBrackets(), this.variable(), new Object[0]), Operator.COMPOSITION);
    }

    Rule isOperation() {
        return this.Sequence(this.selection(), this.push(new OperationBinary(this.currentPosition(), (CompilableExpression)this.pop())), new Object[]{this.ZeroOrMore(this.operator(Operator.IS), this.popValue(), new Object[]{this.mandatory(this.Sequence(this.FirstOf(this.Sequence(this.operator(Operator.NOT), this.popValue(), new Object[]{this.action(this.peek(OperationBinary.class).add(Operator.IS_NOT))}), this.action(this.peek(OperationBinary.class).add(Operator.IS)), new Object[0]), this.FirstOf(this.functionWithBrackets(), this.functionWithTwoWordsAsName(), new Object[]{this.variable(), this.keywordAsVariable(JtwigKeyword.NULL)}), new Object[]{this.action(this.peek(1, OperationBinary.class).add((CompilableExpression)this.pop()))}), new ParseException("Wrong binary operation syntax"))})});
    }

    Rule selection() {
        return this.binary(this.primary(), this.FirstOf(this.functionWithBrackets(), this.mapEntry(), new Object[]{this.variable()}), Operator.SELECTION);
    }

    Rule primary() {
        return this.FirstOf(this.ternaryOperation(), this.elementar(), new Object[0]);
    }

    Rule ternaryOperation() {
        return this.Sequence(this.elementar(), this.push(new OperationTernary(this.currentPosition(), (CompilableExpression)this.pop())), new Object[]{this.symbol(JtwigSymbol.QUESTION), this.mandatory(this.Sequence(this.expression(), this.action(this.peek(1, OperationTernary.class).withTrueExpression((CompilableExpression)this.pop())), new Object[]{this.symbol(JtwigSymbol.DIV), this.expression(), this.action(this.peek(1, OperationTernary.class).withFalseExpression((CompilableExpression)this.pop()))}), new ParseException("Wring ternary operation syntax"))});
    }

    Rule elementar() {
        return this.FirstOf(this.mapEntry(), this.blockFunction(), new Object[]{this.function(), this.map(), this.list(), this.variable(), this.constant(), this.Sequence(this.symbol(JtwigSymbol.OPEN_PARENT), this.expression(), new Object[]{this.symbol(JtwigSymbol.CLOSE_PARENT)})});
    }

    Rule mapEntry() {
        return this.Sequence(this.variable(), this.symbol(JtwigSymbol.OPEN_BRACKET), new Object[]{this.mandatory(this.Sequence(this.expression(), this.symbol(JtwigSymbol.CLOSE_BRACKET), new Object[]{this.push(new MapSelection(this.currentPosition(), this.pop(1, Variable.class), (CompilableExpression)this.pop()))}), new ParseException("Wring map selection syntax"))});
    }

    public Rule function() {
        return this.FirstOf(this.functionWithBrackets(), this.functionWithoutBrackets(), new Object[0]);
    }

    Rule nonExpressionFunction() {
        return this.FirstOf(this.functionWithBrackets(), this.nonExpressionFunctionWithoutBrackets(), new Object[0]);
    }

    Rule functionWithTwoWordsAsName() {
        return this.Sequence(this.basic.identifier(), this.push(new Constant<String>(this.match())), new Object[]{this.basic.spacing(), this.basic.identifier(), this.push(new Constant<String>(this.match())), this.basic.spacing(), this.push(new FunctionElement(this.currentPosition(), this.popVariableName(1) + " " + this.popVariableName())), this.mandatory(this.Sequence(this.expression(), this.action(this.peek(1, FunctionElement.class).add((CompilableExpression)this.pop())), new Object[0]), new ParseException("Wrong function named with two words syntax"))});
    }

    Rule functionWithoutBrackets() {
        return this.Sequence(this.basic.identifier(), this.push(new Constant<String>(this.match())), new Object[]{this.basic.spacing(), this.TestNot(this.basic.spacing(), this.basic.terminal(Operator.SUB.toString()), new Object[0]), this.expression(), this.push(new FunctionElement(this.currentPosition(), this.popVariableName(1))), this.action(this.peek(FunctionElement.class).add((CompilableExpression)this.pop(1)))});
    }

    Rule nonExpressionFunctionWithoutBrackets() {
        return this.Sequence(this.basic.identifier(), this.push(new Constant<String>(this.match())), new Object[]{this.basic.spacing(), this.TestNot(this.basic.spacing(), this.basic.terminal(Operator.SUB.toString()), new Object[0]), this.FirstOf(this.Sequence(this.expression(), this.push(new FunctionElement(this.currentPosition(), this.popVariableName(1))), new Object[]{this.action(this.peek(FunctionElement.class).add((CompilableExpression)this.pop(1)))}), this.push(new FunctionElement(this.currentPosition(), this.popVariableName())), new Object[0])});
    }

    public Rule functionWithBrackets() {
        return this.Sequence(this.identifierAsString(), this.symbol(JtwigSymbol.OPEN_PARENT), new Object[]{this.push(new FunctionElement(this.currentPosition(), this.popIdentifierAsString())), this.mandatory(this.Sequence(this.expression(), this.action(this.peek(1, FunctionElement.class).add((CompilableExpression)this.pop())), new Object[]{this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.expression(), new Object[]{this.action(this.peek(1, FunctionElement.class).add((CompilableExpression)this.pop()))}), this.symbol(JtwigSymbol.CLOSE_PARENT)}), new ParseException("Wrong function syntax"))});
    }

    public Rule blockFunction() {
        return this.Sequence("block", this.basic.spacing(), new Object[]{this.push(new BlockFunction(this.currentPosition())), this.symbol(JtwigSymbol.OPEN_PARENT), this.mandatory(this.Sequence(this.expression(), this.action(this.peek(1, BlockFunction.class).add((CompilableExpression)this.pop())), new Object[]{this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.expression(), new Object[]{this.action(this.peek(1, BlockFunction.class).add((CompilableExpression)this.pop()))}), this.symbol(JtwigSymbol.CLOSE_PARENT)}), new ParseException("Invalid block function syntax"))});
    }

    Rule map() {
        return this.Sequence(this.symbol(JtwigSymbol.OPEN_CURLY_BRACKET), this.push(new ValueMap(this.currentPosition())), new Object[]{this.mandatory(this.Sequence(this.Optional(this.FirstOf(this.constants.string(), this.identifierAsString(), new Object[0]), this.basic.spacing(), new Object[]{this.symbol(JtwigSymbol.DIV), this.expression(), this.action(this.peek(2, ValueMap.class).add(this.popIdentifierAsString(1), (CompilableExpression)this.pop())), this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.FirstOf(this.constants.string(), this.identifierAsString(), new Object[0]), new Object[]{this.basic.spacing(), this.symbol(JtwigSymbol.DIV), this.expression(), this.action(this.peek(2, ValueMap.class).add(this.popIdentifierAsString(1), (CompilableExpression)this.pop()))})}), this.symbol(JtwigSymbol.CLOSE_CURLY_BRACKET), new Object[0]), new ParseException("Wrong map syntax"))});
    }

    Rule list() {
        return this.FirstOf(this.comprehensionList(), this.enumeratedList(), new Object[0]);
    }

    Rule enumeratedList() {
        return this.Sequence(this.symbol(JtwigSymbol.OPEN_BRACKET), this.push(new ValueList(this.currentPosition())), new Object[]{this.mandatory(this.Sequence(this.Optional(this.expression(), this.action(this.peek(1, ValueList.class).add((CompilableExpression)this.pop())), new Object[]{this.ZeroOrMore(this.symbol(JtwigSymbol.COMMA), this.expression(), new Object[]{this.action(this.peek(1, ValueList.class).add((CompilableExpression)this.pop()))})}), this.symbol(JtwigSymbol.CLOSE_BRACKET), new Object[0]), new ParseException("Wrong list syntax"))});
    }

    Rule comprehensionList() {
        return this.Sequence(this.constants.anyConstant(), this.basic.symbol(JtwigSymbol.TWO_DOTS), new Object[]{this.constants.anyConstant(), this.push(ValueList.create(this.currentPosition(), (Constant)this.constants.pop(1), (Constant)this.constants.pop())), this.basic.spacing()});
    }

    public Rule variable() {
        return this.Sequence(this.basic.identifier(), this.push(new Variable(this.currentPosition(), this.match())), new Object[]{this.basic.spacing()});
    }

    public Rule variableAsFunction() {
        return this.Sequence(this.variable(), this.push(this.pop(Variable.class).toFunction()), new Object[0]);
    }

    Rule identifierAsString() {
        return this.Sequence(this.basic.identifier(), this.push(new Constant<String>(this.match())), new Object[]{this.basic.spacing()});
    }

    String popIdentifierAsString() {
        return this.popIdentifierAsString(0);
    }

    String popIdentifierAsString(int position) {
        return this.pop(position, Constant.class).as(String.class);
    }

    Rule constant() {
        return this.Sequence(this.constants.anyConstant(), this.push(this.constants.pop()), new Object[]{this.basic.spacing()});
    }

    @Override
    boolean throwException(ParseException exception) throws ParseBypassException {
        throw new ParseBypassException(exception);
    }

    Rule symbol(JtwigSymbol symbol) {
        return this.Sequence(this.basic.symbol(symbol), this.basic.spacing(), new Object[0]);
    }

    Rule keywordAsVariable(JtwigKeyword keyword) {
        return this.Sequence(this.basic.keyword(keyword), this.push(new Variable(this.currentPosition(), this.basic.match())), new Object[]{this.basic.spacing()});
    }

    @SuppressNode
    Rule firstOperatorOf(Operator ... operators) {
        Object[] rules = new Rule[operators.length];
        int i = 0;
        for (Operator operator : operators) {
            rules[i++] = this.operator(operator);
        }
        return this.FirstOf(rules);
    }

    Rule operator(Operator operator) {
        return this.Sequence(this.TestNot(this.FirstOf(this.basic.closeCode(), this.basic.closeOutput(), new Object[]{this.Sequence(this.basic.symbol(JtwigSymbol.MINUS), this.basic.closeCode(), new Object[0]), this.Sequence(this.basic.symbol(JtwigSymbol.MINUS), this.basic.closeOutput(), new Object[0])})), this.basic.terminal(operator.toString()), new Object[]{this.conditionalSpace(operator.toString()), this.push(new Constant<Operator>(operator)), this.basic.spacing()});
    }

    Rule conditionalSpace(String string) {
        if (string.matches("[a-zA-Z_$][a-zA-Z0-9_$]*")) {
            return this.AnyOf(" \t\r\n\f");
        }
        return this.Test(true);
    }

    public Rule binary(Rule first, Rule rest, Operator ... operators) {
        return this.Sequence(first, this.push(new OperationBinary(this.currentPosition(), (CompilableExpression)this.pop())), new Object[]{this.ZeroOrMore(this.firstOperatorOf(operators), this.action(this.peek(1, OperationBinary.class).add((Operator)((Object)this.pop(Constant.class).getValue()))), new Object[]{this.mandatory(this.Sequence(rest, this.action(this.peek(1, OperationBinary.class).add((CompilableExpression)this.pop())), new Object[0]), new ParseException("Wrong binary operation syntax"))})});
    }

    public Rule binary(Rule innerExpression, Operator ... operators) {
        return this.binary(innerExpression, innerExpression, operators);
    }

    public Rule unary(Rule innerRule, Operator ... operators) {
        return this.Sequence(this.firstOperatorOf(operators), this.push(new OperationUnary.Builder().withPosition(this.currentPosition()).withOperator((Operator)((Object)this.pop(Constant.class).getValue()))), new Object[]{this.mandatory(this.Sequence(innerRule, this.action(this.peek(1, OperationUnary.Builder.class).withOperand((CompilableExpression)this.pop())), new Object[0]), new ParseException("Wrong unary operator syntax")), this.push(this.pop(OperationUnary.Builder.class).build())});
    }

    protected String popVariableName(int i) {
        return (String)this.pop(i, Constant.class).getValue();
    }

    protected String popVariableName() {
        return this.popVariableName(0);
    }

    boolean popValue() {
        this.pop();
        return true;
    }

    @Override
    public <T> T pop(Class<T> typeClass) {
        return this.pop(0, typeClass);
    }

    @Override
    public <T> T pop(int position, Class<T> type) {
        return type.cast(this.pop(position));
    }
}

