/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.render;

import com.google.common.base.Optional;
import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.functions.parameters.convert.DemultiplexerConverter;
import com.lyncode.jtwig.functions.parameters.convert.api.ParameterConverter;
import com.lyncode.jtwig.functions.parameters.convert.impl.ObjectToStringConverter;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.functions.parameters.resolve.api.InputParameterResolverFactory;
import com.lyncode.jtwig.functions.parameters.resolve.api.MethodParametersResolver;
import com.lyncode.jtwig.functions.parameters.resolve.api.ParameterResolver;
import com.lyncode.jtwig.functions.parameters.resolve.impl.InputDelegateMethodParametersResolver;
import com.lyncode.jtwig.functions.parameters.resolve.impl.ParameterAnnotationParameterResolver;
import com.lyncode.jtwig.functions.repository.api.FunctionRepository;
import com.lyncode.jtwig.functions.resolver.api.FunctionResolver;
import com.lyncode.jtwig.functions.resolver.impl.CompoundFunctionResolver;
import com.lyncode.jtwig.functions.resolver.impl.DelegateFunctionResolver;
import com.lyncode.jtwig.functions.resolver.model.Executable;
import com.lyncode.jtwig.render.config.RenderConfiguration;
import com.lyncode.jtwig.render.stream.RenderStream;
import com.lyncode.jtwig.types.Undefined;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RenderContext {
    private static final String MODEL = "model";
    private final FunctionResolver functionResolver;
    private final RenderConfiguration configuration;
    private final JtwigModelMap modelMap;
    private final RenderStream renderStream;

    public static RenderContext create(RenderConfiguration configuration, JtwigModelMap modelMap, OutputStream output) {
        return new RenderContext(configuration, modelMap, (FunctionResolver)new CompoundFunctionResolver().withResolver((FunctionResolver)new DelegateFunctionResolver((FunctionRepository)configuration.functionRepository(), (MethodParametersResolver)new InputDelegateMethodParametersResolver(RenderContext.annotationWithoutConversion()))).withResolver((FunctionResolver)new DelegateFunctionResolver((FunctionRepository)configuration.functionRepository(), (MethodParametersResolver)new InputDelegateMethodParametersResolver(RenderContext.annotationWithConversion()))), new RenderStream(output, configuration.renderThreadingConfig()));
    }

    public static RenderContext create(RenderConfiguration configuration, JtwigModelMap modelMap, FunctionResolver functionResolver, OutputStream output) {
        return new RenderContext(configuration, modelMap, functionResolver, new RenderStream(output, configuration.renderThreadingConfig()));
    }

    private RenderContext(RenderConfiguration configuration, JtwigModelMap modelMap, FunctionResolver functionResolver, RenderStream renderStream) {
        this.configuration = configuration;
        this.modelMap = modelMap;
        this.renderStream = renderStream;
        this.functionResolver = functionResolver;
    }

    public void write(byte[] bytes) throws IOException {
        this.renderStream.write(bytes);
    }

    public RenderStream renderStream() {
        return this.renderStream;
    }

    public RenderContext newRenderContext(OutputStream outputStream) {
        return new RenderContext(this.configuration, this.modelMap, this.functionResolver, new RenderStream(outputStream, this.configuration.renderThreadingConfig()));
    }

    public RenderConfiguration configuration() {
        return this.configuration;
    }

    public void renderConcurrent(Renderable content) throws IOException, RenderException {
        this.renderStream.renderConcurrent(content, this.fork());
    }

    private RenderContext fork() throws IOException {
        return new RenderContext(this.configuration, this.modelMap, this.functionResolver, this.renderStream.fork());
    }

    public RenderContext isolatedModel() {
        return new RenderContext(this.configuration, this.modelMap.clone(), this.functionResolver, this.renderStream);
    }

    public RenderContext with(Map calculate) {
        Set set = calculate.entrySet();
        for (Map.Entry entry : set) {
            this.modelMap.add(entry.getKey().toString(), entry.getValue());
        }
        return this;
    }

    public RenderContext with(String key, Object value) {
        this.modelMap.add(key, value);
        return this;
    }

    public Object map(String key) {
        if (MODEL.equals(key)) {
            return this.modelMap;
        }
        if (this.modelMap.containsKey(key)) {
            return this.modelMap.get(key);
        }
        return Undefined.UNDEFINED;
    }

    public Object executeFunction(String name, InputParameters parameters) throws FunctionException {
        try {
            Optional resolve = this.functionResolver.resolve(name, parameters);
            if (resolve.isPresent()) {
                return ((Executable)resolve.get()).execute();
            }
            String message = "Unable to find function with name '" + name + "'";
            if (parameters.length() > 0) {
                message = message + ", and parameters: ";
                ArrayList<String> params = new ArrayList<String>();
                for (int i = 0; i < parameters.length(); ++i) {
                    params.add(parameters.valueAt(i).getClass().getName());
                }
                message = message + StringUtils.join(params, (String)", ");
            }
            throw new FunctionNotFoundException(message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FunctionException((Throwable)e);
        }
    }

    private static InputParameterResolverFactory annotationWithoutConversion() {
        return new InputParameterResolverFactory(){

            public ParameterResolver create(InputParameters parameters) {
                return new ParameterAnnotationParameterResolver(parameters, new DemultiplexerConverter());
            }
        };
    }

    private static InputParameterResolverFactory annotationWithConversion() {
        return new InputParameterResolverFactory(){

            public ParameterResolver create(InputParameters parameters) {
                return new ParameterAnnotationParameterResolver(parameters, new DemultiplexerConverter().withConverter(String.class, (ParameterConverter)new ObjectToStringConverter()));
            }
        };
    }
}

