/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.render.stream;

import java.io.IOException;
import java.io.OutputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final byte[] buffer;
    private boolean closed;
    private int blockSize;
    private int index;
    private int size;

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int aSize) {
        this.blockSize = aSize;
        this.buffer = new byte[this.blockSize];
    }

    public int getSize() {
        return this.size + this.index;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.getSize()];
        int pos = 0;
        System.arraycopy(this.buffer, 0, data, pos, this.index);
        return data;
    }

    @Override
    public void write(int datum) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.buffer[this.index++] = (byte)datum;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.index);
    }
}

