/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.render.stream;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RenderControl {
    private final AtomicInteger mStackCounter = new AtomicInteger(0);
    private final Semaphore mSemaphore = new Semaphore(0);
    private final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();

    public void waitFinish() throws InterruptedException {
        while (this.mStackCounter.get() > 0) {
            this.mSemaphore.acquire();
        }
    }

    public void push() {
        this.mStackCounter.incrementAndGet();
    }

    public void cancel() {
        int value = this.mStackCounter.getAndSet(0);
        if (value <= 0) {
            this.mSemaphore.release();
        }
    }

    public void poll() {
        int value = this.mStackCounter.decrementAndGet();
        if (value <= 0) {
            this.mSemaphore.release();
        }
    }

    public void lockWrite() {
        this.mLock.readLock().lock();
    }

    public void unlockWrite() {
        this.mLock.readLock().unlock();
    }

    public void lockChange() {
        this.mLock.writeLock().lock();
    }

    public void unlockChange() {
        this.mLock.writeLock().unlock();
    }
}

