/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.render.stream;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class RenderIndex {
    private final int[] mIndex;

    public static RenderIndex newIndex() {
        return new RenderIndex(ArrayUtils.add((int[])new int[0], (int)0));
    }

    public boolean isRoot() {
        return this.mIndex.length == 1 && this.mIndex[0] == 0;
    }

    public boolean isLeft() {
        return this.mIndex[this.mIndex.length - 1] == 0;
    }

    public boolean isRight() {
        return !this.isLeft();
    }

    public boolean isMostLeft() {
        for (int i = 0; i < this.mIndex.length; ++i) {
            if (this.mIndex[i] == 0) continue;
            return false;
        }
        return true;
    }

    public RenderIndex clone() {
        return new RenderIndex(this.getIndex());
    }

    public RenderIndex right() {
        int[] newIndex = ArrayUtils.clone((int[])this.mIndex);
        int n = newIndex.length - 1;
        newIndex[n] = newIndex[n] + 1;
        return new RenderIndex(newIndex);
    }

    public RenderIndex left() {
        return new RenderIndex(ArrayUtils.add((int[])this.getIndex(), (int)0));
    }

    public RenderIndex previous() {
        int[] newIndex = ArrayUtils.clone((int[])this.mIndex);
        if (this.isLeft()) {
            newIndex = ArrayUtils.remove((int[])this.mIndex, (int)(this.mIndex.length - 1));
        } else {
            int n = newIndex.length - 1;
            newIndex[n] = newIndex[n] - 1;
            newIndex = ArrayUtils.add((int[])newIndex, (int)0);
        }
        return new RenderIndex(newIndex);
    }

    private RenderIndex(int[] index) {
        this.mIndex = index;
    }

    private int[] getIndex() {
        return this.mIndex;
    }

    public int hashCode() {
        return Arrays.toString(this.mIndex).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderIndex that = (RenderIndex)o;
        return Arrays.equals(this.mIndex, that.mIndex);
    }
}

