/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.render.stream;

import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.render.config.RenderThreadingConfig;
import com.lyncode.jtwig.render.stream.MultiOuputStream;
import com.lyncode.jtwig.render.stream.RenderControl;
import com.lyncode.jtwig.render.stream.RenderIndex;
import com.lyncode.jtwig.render.stream.RenderTask;
import com.lyncode.jtwig.render.stream.SingleOuputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RenderStream {
    private static ExecutorService sExecutor = null;
    private final OutputStream mRootOutputStream;
    private final MultiOuputStream mMultiStream;
    private final RenderControl mControl;
    private final RenderThreadingConfig mRenderConfiguration;
    private RenderIndex mIndex;

    private static void initExecutorService(RenderThreadingConfig renderConfiguration) {
        if (sExecutor == null) {
            sExecutor = new ThreadPoolExecutor(renderConfiguration.minThreads(), renderConfiguration.maxThreads(), renderConfiguration.keepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
    }

    private RenderStream(MultiOuputStream multiStream, OutputStream stream, RenderIndex dIndex, RenderControl renderControl, RenderThreadingConfig renderConfiguration) {
        this.mMultiStream = multiStream;
        this.mRootOutputStream = stream;
        this.mIndex = dIndex;
        this.mControl = renderControl;
        this.mRenderConfiguration = renderConfiguration;
        RenderStream.initExecutorService(this.mRenderConfiguration);
        if (this.mIndex != null) {
            SingleOuputStream.Builder builder = SingleOuputStream.builder().withInheritedStream(true);
            if (this.mIndex.isMostLeft()) {
                builder.withByteStream(false);
                builder.withStream(stream);
            } else if (this.mIndex.isLeft()) {
                builder.withByteStream(true);
                builder.withStream(multiStream.get(this.mIndex.previous()).getStream());
            }
            multiStream.addStream(this.mIndex, builder.build());
        }
    }

    public RenderStream(OutputStream outputStream, RenderThreadingConfig renderConfiguration) {
        this(new MultiOuputStream(), outputStream, null, new RenderControl(), renderConfiguration);
    }

    public RenderStream renderConcurrent(Renderable content, RenderContext context) {
        try {
            this.mControl.push();
            sExecutor.execute(new RenderTask(content, context));
        }
        catch (OutOfMemoryError e) {
            sExecutor.shutdownNow();
            this.mControl.cancel();
        }
        return this;
    }

    public RenderStream waitForExecutorCompletion() throws RenderException {
        try {
            this.mControl.waitFinish();
        }
        catch (InterruptedException e) {
            throw new RenderException(e);
        }
        return this;
    }

    public RenderStream notifyTaskFinished() {
        this.mControl.poll();
        return this;
    }

    public OutputStream getOuputStream() {
        if (this.mIndex != null) {
            return this.mMultiStream.get(this.mIndex);
        }
        return this.getRootOutputStream();
    }

    public RenderStream write(byte[] bytes) throws IOException {
        this.mControl.lockWrite();
        this.getOuputStream().write(bytes);
        this.mControl.unlockWrite();
        return this;
    }

    public RenderStream close() throws IOException {
        this.mControl.lockWrite();
        if (this.mIndex != null) {
            this.mMultiStream.close(this.mIndex);
        }
        this.mControl.unlockWrite();
        return this;
    }

    public RenderStream fork() throws IOException {
        this.mControl.lockChange();
        if (this.mIndex == null) {
            this.mIndex = RenderIndex.newIndex();
        }
        this.mMultiStream.waitOrder(this.mIndex);
        RenderIndex forkedIndex = this.mIndex.left();
        this.mIndex = this.mIndex.right();
        this.mMultiStream.addStream(this.mIndex);
        RenderStream forkedStream = new RenderStream(this.mMultiStream, this.getRootOutputStream(), forkedIndex, this.mControl, this.mRenderConfiguration);
        this.mControl.unlockChange();
        return forkedStream;
    }

    public RenderStream merge() throws IOException {
        this.mControl.lockChange();
        if (this.mIndex != null && this.mMultiStream.isClosed(this.mIndex)) {
            RenderIndex index = this.mIndex.clone();
            RenderIndex previous = index.previous();
            RenderIndex toMerge = index;
            while (!index.isRoot()) {
                if (this.mMultiStream.isWaitingOrder(previous) && index.isLeft()) {
                    this.mMultiStream.close(previous);
                }
                if (this.mMultiStream.isClosed(previous)) {
                    if (toMerge.isRight()) {
                        this.mergeStreams(previous, toMerge);
                    }
                    this.mMultiStream.merged(toMerge);
                    toMerge = previous;
                    if (this.mMultiStream.isClosed(previous.right())) {
                        this.mergeStreams(previous, previous.right());
                        this.mMultiStream.merged(previous.right());
                    }
                } else if (this.mMultiStream.isOpen(previous) || this.mMultiStream.isWaitingOrder(previous) && !index.isLeft()) {
                    this.mControl.unlockChange();
                    return this;
                }
                index = previous;
                previous = index.previous();
            }
            this.getRootOutputStream().write(this.mMultiStream.get(toMerge).toByteArray());
            this.mMultiStream.merged(toMerge);
        }
        this.mControl.unlockChange();
        return this;
    }

    private void mergeStreams(RenderIndex destinationIndex, RenderIndex originIndex) throws IOException {
        SingleOuputStream singleOuputStream = this.mMultiStream.get(destinationIndex);
        this.mMultiStream.get(originIndex).writeTo(singleOuputStream.getStream());
    }

    private OutputStream getRootOutputStream() {
        return this.mRootOutputStream;
    }
}

