/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.render.stream;

import com.lyncode.jtwig.render.stream.FastByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SingleOuputStream
extends ByteArrayOutputStream {
    private OutputStream mStream;
    private StreamState mStreamState;
    private final boolean mInheritedStream;
    private final boolean mByteStream;

    private SingleOuputStream(Builder builder) {
        this.mStream = builder.mStream;
        this.mInheritedStream = builder.mInheritedStream;
        this.mByteStream = builder.mByteStream;
        this.mStreamState = StreamState.OPEN;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.mByteStream) {
            ((FastByteArrayOutputStream)this.mStream).writeTo(out);
        }
    }

    @Override
    public byte[] toByteArray() {
        if (this.mByteStream) {
            return ((FastByteArrayOutputStream)this.mStream).toByteArray();
        }
        return new byte[0];
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.mStream.write(bytes);
    }

    @Override
    public void flush() throws IOException {
        this.mStream.flush();
    }

    public void setStreamState(StreamState streamState) {
        this.mStreamState = streamState;
    }

    @Override
    public void close() throws IOException {
        this.mStream.flush();
        this.mStreamState = StreamState.CLOSED;
    }

    public void finalize() throws IOException {
        this.close();
        if (!this.mInheritedStream) {
            this.mStream.close();
            this.mStream = null;
        }
    }

    public boolean isClosed() {
        return this.mStreamState.equals((Object)StreamState.CLOSED);
    }

    public boolean isOpen() {
        return this.mStreamState.equals((Object)StreamState.OPEN);
    }

    public boolean isWaiting() {
        return this.mStreamState.equals((Object)StreamState.WAITING);
    }

    public OutputStream getStream() {
        return this.mStream;
    }

    public static final class Builder {
        private OutputStream mStream;
        private boolean mInheritedStream = false;
        private boolean mByteStream = true;

        private Builder() {
        }

        public Builder withStream(OutputStream mStream) {
            this.mStream = mStream;
            return this;
        }

        public Builder withInheritedStream(boolean mInheritedStream) {
            this.mInheritedStream = mInheritedStream;
            return this;
        }

        public Builder withByteStream(boolean mByteStream) {
            this.mByteStream = mByteStream;
            return this;
        }

        public SingleOuputStream build() {
            if (this.mStream == null) {
                this.mStream = new FastByteArrayOutputStream();
            }
            return new SingleOuputStream(this);
        }
    }

    public static enum StreamState {
        OPEN,
        WAITING,
        CLOSED;

    }
}

