/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.resource;

import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.util.FilePath;
import java.io.File;
import java.io.InputStream;

public class ClasspathJtwigResource
implements JtwigResource {
    private static final String PREFIX = "classpath:";
    private String resource;

    public ClasspathJtwigResource(String resource) {
        if (resource.startsWith(PREFIX)) {
            resource = resource.substring(PREFIX.length());
        }
        this.resource = resource.startsWith(File.separator) ? resource.substring(1) : resource;
    }

    @Override
    public boolean exists() {
        return this.getClass().getClassLoader().getResource(this.resource) != null;
    }

    @Override
    public InputStream retrieve() throws ResourceException {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(this.resource);
        if (resourceAsStream == null) {
            throw new ResourceException("Resource '" + this.resource + "' not found");
        }
        return resourceAsStream;
    }

    @Override
    public JtwigResource resolve(String relativePath) throws ResourceException {
        return new ClasspathJtwigResource(FilePath.parentOf(this.resource).append(relativePath).normalize());
    }

    public String toString() {
        return this.resource;
    }
}

