/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.util;

import com.google.common.base.Predicate;
import com.lyncode.jtwig.types.Undefined;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.reflections.ReflectionUtils;

public class ObjectExtractor {
    private Object context;

    public ObjectExtractor(Object context) {
        this.context = context;
    }

    public Object extract(String name, Object ... parameters) throws ExtractException {
        ArrayList<Callable> callables = new ArrayList<Callable>();
        if (parameters.length == 0) {
            callables.add(this.tryField());
        }
        callables.add(this.tryMethod());
        if (this.knownType(this.context)) {
            callables.add(this.tryKnownType());
        }
        for (Callable callable : callables) {
            Result<Object> result = callable.execute(name, parameters);
            if (!((Result)result).hasResult()) continue;
            return ((Result)result).getResult();
        }
        return Undefined.UNDEFINED;
    }

    private Callable tryKnownType() {
        return new Callable(){

            @Override
            public Result<Object> execute(String name, Object ... args) throws ExtractException {
                return new Result<Object>(ObjectExtractor.this.extractKnownType(name, args));
            }
        };
    }

    private Object extractKnownType(String name, Object ... parameters) {
        if (this.context instanceof Map && parameters.length == 0) {
            return ((Map)this.context).get(name);
        }
        return null;
    }

    private boolean knownType(Object context) {
        return context instanceof Map;
    }

    private Callable tryField() {
        return new Callable(){

            @Override
            public Result<Object> execute(String name, Object ... args) {
                Set fields = ReflectionUtils.getAllFields(ObjectExtractor.this.context.getClass(), (Predicate[])new Predicate[]{ObjectExtractor.this.fieldPredicate(name)});
                if (!fields.isEmpty()) {
                    Iterator iterator = fields.iterator();
                    while (iterator.hasNext()) {
                        try {
                            return new Result<Object>(((Field)iterator.next()).get(ObjectExtractor.this.context));
                        }
                        catch (IllegalAccessException e) {
                        }
                    }
                    return new Result<Object>();
                }
                return new Result<Object>();
            }
        };
    }

    private Predicate<Field> fieldPredicate(final String name) {
        return new Predicate<Field>(){

            public boolean apply(@Nullable Field field) {
                if (field == null) {
                    return false;
                }
                return IsEqualIgnoringCase.equalToIgnoringCase((String)name).matches((Object)field.getName());
            }
        };
    }

    private Callable tryMethod() {
        return new Callable(){

            @Override
            public Result<Object> execute(String name, Object ... args) throws ExtractException {
                String[] prefixes = new String[]{"get", "is", "has"};
                Set methods = ReflectionUtils.getAllMethods(ObjectExtractor.this.context.getClass(), (Predicate[])new Predicate[]{ObjectExtractor.this.methodMatcher((Matcher<? super String>)IsEqualIgnoringCase.equalToIgnoringCase((String)name), args.length)});
                int i = 0;
                while (methods.isEmpty() && i < prefixes.length) {
                    methods = ReflectionUtils.getAllMethods(ObjectExtractor.this.context.getClass(), (Predicate[])new Predicate[]{ObjectExtractor.this.methodMatcher((Matcher<? super String>)IsEqualIgnoringCase.equalToIgnoringCase((String)(prefixes[i++] + name)), args.length)});
                }
                if (methods.isEmpty()) {
                    return new Result<Object>();
                }
                Iterator iterator = methods.iterator();
                Exception thrown = null;
                while (iterator.hasNext()) {
                    try {
                        return new Result<Object>(((Method)iterator.next()).invoke(ObjectExtractor.this.context, args));
                    }
                    catch (Exception e) {
                        thrown = e;
                    }
                }
                if (thrown != null) {
                    throw new ExtractException(thrown);
                }
                return new Result<Object>();
            }
        };
    }

    private Predicate<Method> methodMatcher(final Matcher<? super String> nameMatcher, final int numberOfArguments) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method method) {
                if (method == null) {
                    return false;
                }
                return nameMatcher.matches((Object)method.getName()) && method.getParameterTypes().length == numberOfArguments;
            }
        };
    }

    public static class ExtractException
    extends Exception {
        public ExtractException(String message) {
            super(message);
        }

        public ExtractException(Throwable cause) {
            super(cause);
        }
    }

    private static class Result<T> {
        private T result;
        private boolean has;

        public Result() {
            this.has = false;
        }

        public Result(T result) {
            this.has = true;
            this.result = result;
        }

        private T getResult() {
            return this.result;
        }

        private boolean hasResult() {
            return this.has;
        }
    }

    private static interface Callable {
        public Result<Object> execute(String var1, Object ... var2) throws ExtractException;
    }
}

