/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.bool;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.JtwigFunctionDeclaration;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.collection.IsEmptyCollection;

@JtwigFunctionDeclaration(name="empty")
public class Empty
implements JtwigFunction {
    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        Requirements.requires(arguments).withNumberOfArguments((Matcher<Integer>)CoreMatchers.equalTo((Object)1));
        return this.anyOf(arguments[0], CoreMatchers.nullValue(Object.class), this.emptyList(), this.emptyMap(), this.notHasNext(), this.zeroValue());
    }

    private boolean anyOf(Object value, Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            if (!matcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    private Matcher<Object> emptyMap() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                if (item instanceof Map) {
                    return ((Map)item).isEmpty();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)IsEmptyCollection.empty());
            }
        };
    }

    private Matcher<Object> zeroValue() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return CoreMatchers.equalTo((Object)0).matches(item);
            }

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)CoreMatchers.equalTo((Object)0));
            }
        };
    }

    private Matcher<Object> emptyList() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return IsEmptyCollection.empty().matches(item);
            }

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)IsEmptyCollection.empty());
            }
        };
    }

    private Matcher<Object> notHasNext() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                if (item instanceof Iterable) {
                    return !((Iterable)item).iterator().hasNext();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("not has next");
            }
        };
    }
}

