/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.builtin;

import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateFunctions {
    private static final String MODIFY_PATTERN = "^([\\\\+\\\\-])([0-9]+) ([a-zA-Z]+)$";

    @JtwigFunction(name="date_modify")
    public Date modifyDate(@Parameter Date input, @Parameter String modifyString) throws FunctionException {
        Calendar instance = Calendar.getInstance();
        instance.setTime(input);
        Matcher matcher = Pattern.compile(MODIFY_PATTERN).matcher(modifyString);
        matcher.find();
        int signal = 1;
        if (matcher.group(1).equals("-")) {
            signal = -1;
        }
        int val = Integer.valueOf(matcher.group(2)) * signal;
        String type = matcher.group(3).toLowerCase();
        if (type.startsWith("day")) {
            instance.add(6, val);
        } else if (type.startsWith("month")) {
            instance.add(2, val);
        } else if (type.startsWith("year")) {
            instance.add(1, val);
        } else if (type.startsWith("second")) {
            instance.add(13, val);
        } else if (type.startsWith("hour")) {
            instance.add(10, val);
        } else if (type.startsWith("minute")) {
            instance.add(12, val);
        } else {
            throw new FunctionException("Unknown type " + matcher.group(3));
        }
        return instance.getTime();
    }

    @JtwigFunction(name="date")
    public String format(@Parameter Date input, @Parameter String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(input);
    }

    @JtwigFunction(name="date")
    public String format(@Parameter Date input) {
        return this.format(input, "yyyy-MM-dd HH:mm:ss");
    }
}

