/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.builtin;

import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class NumberFunctions {
    @JtwigFunction(name="number_format")
    public String numberFormat(@Parameter Object number, @Parameter Integer fractionDigits, @Parameter String decimalSeparator, @Parameter String groupingSeparator) {
        number = number == null ? Integer.valueOf(0) : number;
        DecimalFormat numberFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
        if (fractionDigits != null) {
            numberFormat.setMaximumFractionDigits(fractionDigits);
            numberFormat.setMinimumFractionDigits(fractionDigits);
        }
        if (decimalSeparator != null && !decimalSeparator.isEmpty()) {
            decimalFormatSymbols.setDecimalSeparator(decimalSeparator.charAt(0));
        } else {
            decimalFormatSymbols.setDecimalSeparator('.');
        }
        if (groupingSeparator != null && !groupingSeparator.isEmpty()) {
            decimalFormatSymbols.setGroupingSeparator(groupingSeparator.charAt(0));
        } else {
            numberFormat.setGroupingUsed(false);
        }
        numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return numberFormat.format(number);
    }

    @JtwigFunction(name="number_format")
    public String numberFormat(@Parameter Object number, @Parameter Integer fractionDigits, @Parameter String decimalSeparator) {
        return this.numberFormat(number, fractionDigits, decimalSeparator, null);
    }

    @JtwigFunction(name="number_format")
    public String numberFormat(@Parameter Object number, @Parameter Integer fractionDigits) {
        return this.numberFormat(number, fractionDigits, null, null);
    }

    @JtwigFunction(name="number_format")
    public String numberFormat(@Parameter Object number) {
        return this.numberFormat(number, null, null, null);
    }

    @JtwigFunction(name="range")
    public List<Integer> range(@Parameter int start, @Parameter int end, @Parameter int step) throws FunctionException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (start == end) {
            result.add(start);
            return result;
        }
        if (step == 0) {
            throw new FunctionException("Step must not be 0");
        }
        if (start > end && step > 0) {
            step = -step;
        }
        if (Math.abs(step) > Math.abs(start - end)) {
            throw new FunctionException("Step is too big");
        }
        int i = start;
        while (step > 0 ? i <= end : i >= end) {
            result.add(i);
            i += step;
        }
        return result;
    }

    @JtwigFunction(name="range")
    public List<Integer> range(@Parameter int start, @Parameter int end) throws FunctionException {
        return this.range(start, end, 1);
    }
}

