/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.builtin;

import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.types.Undefined;
import java.lang.reflect.Array;

public class ObjectFunctions {
    @JtwigFunction(name="default")
    public Object defaultFunction(@Parameter Object input, @Parameter Object defaultValue) {
        if (input == null || input.equals(Undefined.UNDEFINED)) {
            return defaultValue;
        }
        return input;
    }

    @JtwigFunction(name="length")
    public int length(@Parameter Object input) {
        if (input instanceof String) {
            return ((String)input).length();
        }
        return 1;
    }

    @JtwigFunction(name="first")
    public Object first(@Parameter Object input) {
        if (input == null) {
            return input;
        }
        if (input.getClass().isArray()) {
            if (Array.getLength(input) == 0) {
                return null;
            }
            return Array.get(input, 0);
        }
        return input;
    }

    @JtwigFunction(name="last")
    public Object last(@Parameter Object input) {
        if (input == null) {
            return input;
        }
        if (input.getClass().isArray()) {
            int length = Array.getLength(input);
            if (length == 0) {
                return null;
            }
            return Array.get(input, length - 1);
        }
        return input;
    }

    @JtwigFunction(name="toDouble", aliases={"toFloat"})
    public Double toDouble(@Parameter Object input) {
        return Double.valueOf(input.toString());
    }

    @JtwigFunction(name="toInt")
    public Integer toInt(@Parameter Object input) {
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        return Integer.parseInt(input.toString());
    }
}

