/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.parameters.resolve.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.functions.parameters.resolve.api.ParameterResolver;
import com.lyncode.jtwig.functions.reflection.JavaMethodParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class ResolvedParameters {
    private final List<SpecificationAndValue> parameters = new ArrayList<SpecificationAndValue>();

    public ResolvedParameters(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.parameters.add(i, new SpecificationAndValue(new JavaMethodParameter(i, method)));
        }
    }

    public ResolvedParameters resolve(JavaMethodParameter parameter, Object value) {
        this.parameters.get(parameter.position()).value = Optional.of((Object)new ParameterResolver.Value(value));
        return this;
    }

    public boolean isFullyResolved() {
        return Collections2.filter(this.parameters, this.valueIsAbsent()).isEmpty();
    }

    public Object[] values() {
        return Collections2.transform(this.parameters, this.extractValues()).toArray();
    }

    public Collection<JavaMethodParameter> unresolvedParameters() {
        return Collections2.transform((Collection)Collections2.filter(this.parameters, this.valueIsAbsent()), this.extractSpecification());
    }

    private Function<SpecificationAndValue, JavaMethodParameter> extractSpecification() {
        return new Function<SpecificationAndValue, JavaMethodParameter>(){

            @Nullable
            public JavaMethodParameter apply(@Nullable SpecificationAndValue input) {
                return input.specification;
            }
        };
    }

    private Predicate<SpecificationAndValue> valueIsAbsent() {
        return new Predicate<SpecificationAndValue>(){

            public boolean apply(@Nullable SpecificationAndValue input) {
                return !input.value.isPresent();
            }
        };
    }

    private Function<? super SpecificationAndValue, Object> extractValues() {
        return new Function<SpecificationAndValue, Object>(){

            @Nullable
            public Object apply(@Nullable SpecificationAndValue input) {
                return ((ParameterResolver.Value)input.value.get()).value();
            }
        };
    }

    public boolean resolvableBy(InputParameters parameters) {
        return true;
    }

    private class SpecificationAndValue {
        private final JavaMethodParameter specification;
        private Optional<ParameterResolver.Value> value;

        private SpecificationAndValue(JavaMethodParameter specification) {
            this.specification = specification;
            this.value = Optional.absent();
        }
    }
}

