/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class JavaMethodParameter {
    private final int position;
    private final Method method;
    private boolean varArg;

    public JavaMethodParameter(int position, Method method) {
        this.position = position;
        this.method = method;
    }

    public boolean hasAnnotation(Class<?> parameterClass) {
        Annotation[] annotations = this.method.getParameterAnnotations()[this.position];
        return this.containsAnnotation(parameterClass, annotations);
    }

    public Class<?> type() {
        return this.method.getParameterTypes()[this.position];
    }

    public int annotationIndex(Class<?> annotationClass) {
        int count = 0;
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        for (int i = 0; i < this.position; ++i) {
            if (!this.containsAnnotation(annotationClass, parameterAnnotations[i])) continue;
            ++count;
        }
        return count;
    }

    private boolean containsAnnotation(Class<?> parameterClass, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(parameterClass)) continue;
            return true;
        }
        return false;
    }

    public int position() {
        return this.position;
    }

    public boolean isVarArg() {
        return this.method.isVarArgs() && this.position == this.method.getParameterTypes().length - 1;
    }
}

