/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.repository.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Function
implements Comparable<Function> {
    private final Object holder;
    private final Method method;

    public static FunctionBuilder functionFrom(Method method) {
        return new FunctionBuilder(method);
    }

    private Function(Object holder, Method method) {
        this.holder = holder;
        this.method = method;
    }

    public Method method() {
        return this.method;
    }

    public Object holder() {
        return this.holder;
    }

    @Override
    public int compareTo(Function other) {
        if (this.numberOfArguments() > 0 && other.numberOfArguments() == this.numberOfArguments()) {
            int compareResult = 0;
            for (int i = 0; i < this.numberOfArguments(); ++i) {
                Class<Object> type = this.getType(i);
                Class<Object> otherType = other.getType(i);
                if (type.equals(String.class) && otherType.equals(Object.class)) {
                    --compareResult;
                    continue;
                }
                if (type.equals(Object.class) && otherType.equals(String.class)) {
                    ++compareResult;
                    continue;
                }
                if (type.equals(String.class)) {
                    type = Object.class;
                }
                if (otherType.equals(String.class)) {
                    otherType = Object.class;
                }
                if (type.equals(otherType)) continue;
                if (type.isAssignableFrom(otherType)) {
                    ++compareResult;
                    continue;
                }
                if (!otherType.isAssignableFrom(type)) continue;
                --compareResult;
            }
            return compareResult;
        }
        return Integer.compare(this.numberOfArguments(), other.numberOfArguments()) * -1;
    }

    private Class<?> getType(int i) {
        return this.method.getParameterTypes()[i];
    }

    private int numberOfArguments() {
        return this.method.getParameterTypes().length;
    }

    public List<Class<?>> getParameterTypesWithAnnotation(Class<? extends Annotation> parameterClass) {
        ArrayList result = new ArrayList();
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = parameterAnnotations[i]) {
                if (!annotation.annotationType().equals(parameterClass)) continue;
                result.add(this.method.getParameterTypes()[i]);
                continue block0;
            }
        }
        return result;
    }

    public static class FunctionBuilder {
        private Method method;

        public FunctionBuilder(Method method) {
            this.method = method;
        }

        public Function on(Object instance) {
            return new Function(instance, this.method);
        }
    }
}

