/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.resolver.impl;

import com.google.common.base.Optional;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.functions.parameters.resolve.api.MethodParametersResolver;
import com.lyncode.jtwig.functions.parameters.resolve.model.ResolvedParameters;
import com.lyncode.jtwig.functions.repository.api.FunctionRepository;
import com.lyncode.jtwig.functions.repository.model.Function;
import com.lyncode.jtwig.functions.resolver.api.FunctionResolver;
import com.lyncode.jtwig.functions.resolver.model.Executable;
import java.util.Collection;

public class DelegateFunctionResolver
implements FunctionResolver {
    private final FunctionRepository repository;
    private final MethodParametersResolver parametersResolver;

    public DelegateFunctionResolver(FunctionRepository repository, MethodParametersResolver parametersResolver) {
        this.repository = repository;
        this.parametersResolver = parametersResolver;
    }

    @Override
    public Optional<Executable> resolve(String name, InputParameters parameters) {
        Collection<Function> functions = this.repository.retrieve(name, parameters);
        for (Function function : functions) {
            ResolvedParameters resolvedParameters = new ResolvedParameters(function.method());
            if (!(resolvedParameters = this.parametersResolver.resolve(resolvedParameters, parameters)).isFullyResolved()) continue;
            return Optional.of((Object)new Executable(function, resolvedParameters.values()));
        }
        return Optional.absent();
    }
}

