/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.mvc;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.builders.FunctionRepositoryBuilder;
import com.lyncode.jtwig.functions.repository.AbstractFunctionRepository;
import com.lyncode.jtwig.functions.repository.WebFunctionRepository;
import com.lyncode.jtwig.mvc.JtwigView;
import com.lyncode.jtwig.services.api.theme.ThemePrefixResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public class JtwigViewResolver
extends AbstractTemplateViewResolver {
    private String encoding;
    private String theme;
    private boolean cached;
    private ThemePrefixResolver prefixResolver;
    private AbstractFunctionRepository functionRepository = new WebFunctionRepository();
    private List<String> loadedFunctions = new ArrayList<String>();

    private static ThemePrefixResolver defaultPrefixResolver() {
        return new ThemePrefixResolver(){

            @Override
            public String getPrefix(String prefix, String theme) {
                return new File(prefix, theme).getPath();
            }
        };
    }

    public JtwigViewResolver() {
        this.prefixResolver = JtwigViewResolver.defaultPrefixResolver();
        this.setViewClass(this.requiredViewClass());
        this.setContentType("text/html; charset=UTF-8");
    }

    protected Class<?> requiredViewClass() {
        return JtwigView.class;
    }

    protected String getPrefix() {
        if (this.hasTheme()) {
            return this.getPrefixWithTheme();
        }
        return super.getPrefix();
    }

    private String getPrefixWithTheme() {
        String prefix = this.prefixResolver.getPrefix(super.getPrefix(), this.getTheme());
        if (super.getPrefix().endsWith(File.separator)) {
            prefix = prefix + File.separator;
        }
        return prefix;
    }

    public boolean isCached() {
        return this.cached;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean hasTheme() {
        return StringUtils.isNotBlank((CharSequence)this.theme);
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFunctionRepository(AbstractFunctionRepository abstractFunctionRepository) {
        this.functionRepository = abstractFunctionRepository;
    }

    public void setFunctionRepository(FunctionRepositoryBuilder functionRepository) {
        this.functionRepository = functionRepository.build();
    }

    public AbstractFunctionRepository getFunctionRepository() {
        return this.functionRepository;
    }

    public void addFunctions(Class<? extends JtwigFunction> ... functionClasses) {
        for (Class<? extends JtwigFunction> functionClass : functionClasses) {
            try {
                if (this.loadedFunctions.contains(functionClass.getName())) continue;
                this.functionRepository.add(functionClass.newInstance());
                this.loadedFunctions.add(functionClass.getName());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to create instance of jtwig function " + functionClass.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to create instance of jtwig function " + functionClass.getName());
            }
        }
    }

    public void addFunctionPackages(String ... packages) {
        for (String pack : packages) {
            Reflections reflections = new Reflections(pack, new Scanner[0]);
            Set functions = reflections.getSubTypesOf(JtwigFunction.class);
            this.addFunctions(functions.toArray(new Class[functions.size()]));
        }
    }
}

