/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions;

import com.lyncode.jtwig.exceptions.AssetResolveException;
import com.lyncode.jtwig.functions.annotations.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.Parameter;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.services.api.assets.AssetResolver;
import com.lyncode.jtwig.util.FilePath;
import com.lyncode.jtwig.util.render.RenderHttpServletRequest;
import com.lyncode.jtwig.util.render.RenderHttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.LocaleResolver;

public class SpringFunctions {
    @Autowired(required=false)
    private AssetResolver assetResolver;
    @Autowired(required=false)
    private MessageSource messageSource;
    @Autowired(required=false)
    private LocaleResolver localeResolver;
    @Autowired(required=false)
    private Environment environment;

    @JtwigFunction(name="asset")
    public String asset(HttpServletRequest request, @Parameter String input) throws AssetResolveException, FunctionException {
        if (this.assetResolver == null) {
            throw new FunctionException("In order to use the asset function, a bean of type " + AssetResolver.class.getName() + " must be configured");
        }
        return new FilePath(request.getContextPath(), this.assetResolver.resolve(input)).toString();
    }

    @JtwigFunction(name="path")
    public String path(HttpServletRequest request, @Parameter String input) {
        return new FilePath(request.getContextPath(), input).toString();
    }

    @JtwigFunction(name="translate", aliases={"message", "trans"})
    public String translate(HttpServletRequest request, @Parameter String input, Object ... rest) throws FunctionException {
        if (this.messageSource == null) {
            throw new FunctionException("In order to use the translate function, a bean of type " + MessageSource.class.getName() + " must be configured");
        }
        if (this.localeResolver == null) {
            throw new FunctionException("In order to use the translate function, a bean of type " + LocaleResolver.class.getName() + " must be configured");
        }
        return this.messageSource.getMessage(input, rest, this.localeResolver.resolveLocale(request));
    }

    @JtwigFunction(name="property")
    public Object property(@Parameter String name) throws FunctionException {
        if (this.environment == null) {
            throw new FunctionException("Unable to retrieve Environment bean");
        }
        return this.environment.getProperty(name);
    }

    @JtwigFunction(name="render")
    public String render(HttpServletRequest request, @Parameter String url) throws FunctionException {
        return this.render(request, url, new HashMap<String, String>());
    }

    @JtwigFunction(name="render")
    public String render(HttpServletRequest request, @Parameter String url, @Parameter Map<String, String> parameters) throws FunctionException {
        RenderHttpServletResponse responseWrapper = new RenderHttpServletResponse();
        RenderHttpServletRequest builder = new RenderHttpServletRequest(request).to(url).withMethod(HttpMethod.GET);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            builder.withGetParameter(entry.getKey(), entry.getValue());
        }
        try {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(request.getServletPath());
            requestDispatcher.include((ServletRequest)builder, (ServletResponse)responseWrapper);
            return responseWrapper.toString();
        }
        catch (IOException | ServletException e) {
            throw new FunctionException(e);
        }
    }
}

