/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.mvc;

import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.jtwig.JtwigTemplate;
import com.lyncode.jtwig.beans.BeanResolver;
import com.lyncode.jtwig.configuration.JtwigConfiguration;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.functions.resolver.api.FunctionResolver;
import com.lyncode.jtwig.mvc.JtwigViewResolver;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.render.config.RenderConfiguration;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.types.Undefined;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.ui.context.Theme;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class JtwigView
extends AbstractTemplateView {
    private static Logger log = LoggerFactory.getLogger(JtwigView.class);
    private Map<String, Renderable> compiledTemplates = new HashMap<String, Renderable>();

    protected String getEncoding() {
        return this.getViewResolver().getEncoding();
    }

    protected JtwigConfiguration getConfiguration() {
        return this.getViewResolver().configuration();
    }

    private JtwigViewResolver getViewResolver() {
        return (JtwigViewResolver)((Object)this.getApplicationContext().getBean(JtwigViewResolver.class));
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        GenericServletAdapter servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig());
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", (Throwable)ex);
        }
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JtwigModelMap modelMap = new JtwigModelMap().add(model).add("beans", (Object)new BeanResolver(this.getApplicationContext())).add("theme", (Object)this.getThemeName(request)).add("request", (Object)request);
        Object token = request.getAttribute("org.springframework.security.web.csrf.CsrfToken");
        if (token != null) {
            modelMap.add("csrf", token);
        } else {
            modelMap.add("csrf", (Object)Undefined.UNDEFINED);
        }
        if (log.isDebugEnabled()) {
            log.debug("Rendering Jtwig templates [" + this.getUrl() + "] in JtwigView '" + this.getBeanName() + "'");
            log.debug("Model: " + modelMap);
        }
        if (this.getEncoding() != null) {
            response.setCharacterEncoding(this.getEncoding());
        }
        this.getContent().render(RenderContext.create((RenderConfiguration)this.getConfiguration().render(), (JtwigModelMap)modelMap, (FunctionResolver)this.getViewResolver().functionResolver(), (OutputStream)response.getOutputStream()));
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    private String getThemeName(HttpServletRequest request) {
        Theme theme = RequestContextUtils.getTheme((HttpServletRequest)request);
        if (theme == null) {
            return null;
        }
        return theme.getName();
    }

    public Renderable getContent() throws CompileException, ParseException {
        if (this.getViewResolver().isCached()) {
            return this.getViewResolver().cache().get(this.getUrl(), new Callable<Renderable>(){

                @Override
                public Renderable call() throws Exception {
                    return JtwigView.this.getCompiledJtwigTemplate();
                }
            });
        }
        return this.getCompiledJtwigTemplate();
    }

    private Renderable getCompiledJtwigTemplate() throws ParseException, CompileException {
        return new JtwigTemplate(this.getResource(), this.getConfiguration()).compile();
    }

    private JtwigResource getResource() {
        return this.getViewResolver().resourceLoader().resolve(this.getUrl());
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return JtwigView.this.getBeanName();
        }

        public ServletContext getServletContext() {
            return JtwigView.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
    }

    private static class GenericServletAdapter
    extends GenericServlet {
        private GenericServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

