/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.mvc;

import com.lyncode.jtwig.cache.JtwigTemplateCacheSystem;
import com.lyncode.jtwig.cache.impl.PersistentTemplateCacheSystem;
import com.lyncode.jtwig.configuration.JtwigConfiguration;
import com.lyncode.jtwig.functions.SpringFunctions;
import com.lyncode.jtwig.functions.parameters.convert.DemultiplexerConverter;
import com.lyncode.jtwig.functions.parameters.convert.api.ParameterConverter;
import com.lyncode.jtwig.functions.parameters.convert.impl.ObjectToStringConverter;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.functions.parameters.resolve.HttpRequestParameterResolver;
import com.lyncode.jtwig.functions.parameters.resolve.api.InputParameterResolverFactory;
import com.lyncode.jtwig.functions.parameters.resolve.api.MethodParametersResolver;
import com.lyncode.jtwig.functions.parameters.resolve.api.ParameterResolver;
import com.lyncode.jtwig.functions.parameters.resolve.impl.CompoundParameterResolver;
import com.lyncode.jtwig.functions.parameters.resolve.impl.InputDelegateMethodParametersResolver;
import com.lyncode.jtwig.functions.parameters.resolve.impl.ParameterAnnotationParameterResolver;
import com.lyncode.jtwig.functions.repository.api.FunctionRepository;
import com.lyncode.jtwig.functions.resolver.api.FunctionResolver;
import com.lyncode.jtwig.functions.resolver.impl.CompoundFunctionResolver;
import com.lyncode.jtwig.functions.resolver.impl.DelegateFunctionResolver;
import com.lyncode.jtwig.mvc.JtwigView;
import com.lyncode.jtwig.resource.loader.DefaultResourceResolver;
import com.lyncode.jtwig.resource.loader.JtwigResourceResolver;
import com.lyncode.jtwig.services.api.url.ResourceUrlResolver;
import com.lyncode.jtwig.services.impl.url.IdentityUrlResolver;
import com.lyncode.jtwig.services.impl.url.ThemedResourceUrlResolver;
import com.lyncode.jtwig.util.LocalThreadHolder;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class JtwigViewResolver
extends AbstractTemplateViewResolver {
    private ThemeResolver themeResolver;
    private String encoding;
    private boolean cached = true;
    private boolean useThemeInViewPath = false;
    private JtwigResourceResolver loader;
    private JtwigConfiguration configuration = new JtwigConfiguration();
    private SpringFunctions springFunctions = null;
    private CompoundParameterResolver parameterResolver = new CompoundParameterResolver();
    private CompoundFunctionResolver functionResolver = new CompoundFunctionResolver().withResolver((FunctionResolver)this.resolver(new DemultiplexerConverter())).withResolver((FunctionResolver)this.resolver(new DemultiplexerConverter().withConverter(String.class, (ParameterConverter)new ObjectToStringConverter())));
    private JtwigTemplateCacheSystem cache = new PersistentTemplateCacheSystem();

    public JtwigViewResolver() {
        this.setViewClass(this.requiredViewClass());
        this.setContentType("text/html; charset=UTF-8");
        this.parameterResolver.withResolver((ParameterResolver)new HttpRequestParameterResolver());
    }

    protected Class<?> requiredViewClass() {
        return JtwigView.class;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        AbstractUrlBasedView abstractUrlBasedView = super.buildView(viewName);
        abstractUrlBasedView.setUrl(this.urlResolver().resolve(this.getPrefix(), viewName, this.getSuffix()));
        return abstractUrlBasedView;
    }

    @Deprecated
    public JtwigViewResolver setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public JtwigViewResolver setThemeResolver(ThemeResolver themeResolver) {
        this.themeResolver = themeResolver;
        return this;
    }

    public JtwigViewResolver setUseThemeInViewPath(boolean useThemeInViewPath) {
        this.useThemeInViewPath = useThemeInViewPath;
        return this;
    }

    @Deprecated
    public JtwigViewResolver setConcurrentMaxThreads(int value) {
        this.configuration.render().renderThreadingConfig().maxThreads(value);
        return this;
    }

    @Deprecated
    public JtwigViewResolver setConcurrentMinThreads(int value) {
        this.configuration.render().renderThreadingConfig().minThreads(value);
        return this;
    }

    public FunctionResolver functionResolver() {
        if (this.springFunctions == null) {
            this.springFunctions = new SpringFunctions();
            this.getApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)this.springFunctions);
            this.configuration.render().functionRepository().include((Object)this.springFunctions);
        }
        return this.functionResolver;
    }

    public JtwigViewResolver setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public JtwigConfiguration configuration() {
        return this.configuration;
    }

    public JtwigViewResolver setConfiguration(JtwigConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JtwigViewResolver include(ParameterResolver resolver) {
        this.parameterResolver.withResolver(resolver);
        return this;
    }

    public JtwigViewResolver includeFunctions(Object functionBean) {
        this.configuration.render().functionRepository().include(functionBean);
        return this;
    }

    public JtwigViewResolver setResourceLoader(JtwigResourceResolver resourceLoader) {
        this.loader = resourceLoader;
        return this;
    }

    public JtwigViewResolver setCacheSystem(JtwigTemplateCacheSystem cache) {
        this.cache = cache;
        return this;
    }

    public boolean useThemeInViewPath() {
        return this.useThemeInViewPath;
    }

    JtwigResourceResolver resourceLoader() {
        if (this.loader == null) {
            this.setResourceLoader(new DefaultResourceResolver(this.getServletContext()));
        }
        return this.loader;
    }

    String getEncoding() {
        return this.encoding;
    }

    boolean isCached() {
        return this.cached;
    }

    JtwigTemplateCacheSystem cache() {
        return this.cache;
    }

    private InputParameterResolverFactory parameterResolverFactory(final DemultiplexerConverter converter) {
        return new InputParameterResolverFactory(){

            public ParameterResolver create(InputParameters parameters) {
                return new CompoundParameterResolver().withResolver((ParameterResolver)new ParameterAnnotationParameterResolver(parameters, converter)).withResolver((ParameterResolver)JtwigViewResolver.this.parameterResolver);
            }
        };
    }

    private DelegateFunctionResolver resolver(DemultiplexerConverter converter) {
        return new DelegateFunctionResolver((FunctionRepository)this.configuration.render().functionRepository(), (MethodParametersResolver)new InputDelegateMethodParametersResolver(this.parameterResolverFactory(converter)));
    }

    private ResourceUrlResolver urlResolver() {
        if (this.themeResolver == null || !this.useThemeInViewPath) {
            return IdentityUrlResolver.INSTANCE;
        }
        return new ThemedResourceUrlResolver(this.themeResolver.resolveThemeName(LocalThreadHolder.getServletRequest()));
    }
}

