/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.resource;

import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.util.FilePath;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.servlet.ServletContext;

public class WebJtwigResource
implements JtwigResource {
    private final ServletContext servletContext;
    private final String url;

    public WebJtwigResource(ServletContext servletContext, String url) {
        this.servletContext = servletContext;
        this.url = url;
    }

    public boolean exists() {
        try {
            return this.servletContext.getResource(this.url) != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public InputStream retrieve() throws ResourceException {
        InputStream resourceAsStream = this.servletContext.getResourceAsStream(this.url);
        if (resourceAsStream == null) {
            throw new ResourceException("Resource " + this.url + " not found");
        }
        return resourceAsStream;
    }

    public JtwigResource resolve(String relativePath) throws ResourceException {
        return new WebJtwigResource(this.servletContext, FilePath.parentOf((String)this.url).append(relativePath).toString());
    }
}

