/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.services.impl.assets;

import com.lyncode.jtwig.exceptions.AssetResolveException;
import com.lyncode.jtwig.mvc.JtwigViewResolver;
import com.lyncode.jtwig.services.api.assets.AssetResolver;
import com.lyncode.jtwig.util.FilePath;
import com.lyncode.jtwig.util.LocalThreadHolder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.context.Theme;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class BaseAssetResolver
implements AssetResolver {
    private String prefix;
    @Autowired
    private ViewResolver viewResolver;

    @Override
    public String resolve(String asset) throws AssetResolveException {
        Theme theme;
        if (this.prefix == null) {
            this.prefix = "/";
        }
        if (!(this.viewResolver instanceof JtwigViewResolver)) {
            throw new AssetResolveException("The view resolver must be a JtwigViewResolver");
        }
        if (((JtwigViewResolver)this.viewResolver).useThemeInViewPath() && (theme = RequestContextUtils.getTheme((HttpServletRequest)LocalThreadHolder.getServletRequest())) != null) {
            return FilePath.path((String)this.prefix).append(theme.getName()).append(asset).toString();
        }
        return FilePath.path((String)this.prefix).append(asset).toString();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

