/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.util;

import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSnapshot {
    private static Logger LOG = LoggerFactory.getLogger(ObjectSnapshot.class);

    public static <T> T snapshot(T object) {
        Class<?> objectClass = object.getClass();
        return ObjectSnapshot.snapshot(object, objectClass);
    }

    public static <T> T snapshot(T object, Class<T> objectClass) {
        return objectClass.cast(Proxy.newProxyInstance(objectClass.getClassLoader(), new Class[]{objectClass}, (InvocationHandler)((Object)new SnapshotInvocationHandler(object))));
    }

    private static class StoreException {
        private final Throwable e;

        private StoreException(Throwable e) {
            this.e = e;
        }
    }

    private static class SnapshotInvocationHandler
    extends AbstractInvocationHandler {
        private final Object object;
        private final Map<String, Object> snapshotMap = new HashMap<String, Object>();

        private SnapshotInvocationHandler(Object object) {
            this.object = object;
            for (Method method : object.getClass().getMethods()) {
                if (Void.TYPE == method.getReturnType() || method.getParameterTypes().length != 0) continue;
                try {
                    this.snapshotMap.put(method.getName(), method.invoke(object, new Object[0]));
                }
                catch (Throwable e) {
                    this.snapshotMap.put(method.getName(), new StoreException(e));
                }
            }
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (Void.TYPE != method.getReturnType()) {
                if (args.length == 0) {
                    Object result = this.snapshotMap.get(method.getName());
                    if (result instanceof StoreException) {
                        throw ((StoreException)result).e;
                    }
                    return result;
                }
                LOG.debug("Unable to create a snapshot of a method with arguments");
            }
            return null;
        }
    }
}

