/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.util.render;

import com.lyncode.jtwig.util.FilePath;
import com.lyncode.jtwig.util.ObjectSnapshot;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.parboiled.common.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class RenderHttpServletRequest
implements HttpServletRequest {
    private static Logger LOG = LoggerFactory.getLogger(RenderHttpServletRequest.class);
    private static final String URL_GET_ATTR = "=";
    private static final String URL_GET_SEPARATOR = "&amp;";
    private HttpMethod method = HttpMethod.GET;
    private String relativeUrl;
    private Map<String, List<String>> getParameters = new LinkedHashMap<String, List<String>>();
    private InputStream content = new ByteArrayInputStream("".getBytes());
    private MediaType mediaType = MediaType.APPLICATION_JSON;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, List<String>> postParameters = new HashMap<String, List<String>>();
    private Map<String, Object> headers = new HashMap<String, Object>();
    private final HttpServletRequest initialValues;
    private RequestDispatcher requestDispatcher;
    private String realPath;

    public RenderHttpServletRequest(HttpServletRequest initialRequest) {
        this.initialValues = ObjectSnapshot.snapshot(initialRequest, HttpServletRequest.class);
        Enumeration attributeNames = initialRequest.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                String name = (String)attributeNames.nextElement();
                this.attributes.put(name, initialRequest.getAttribute(name));
            }
        }
        this.realPath = initialRequest.getRealPath("");
        this.requestDispatcher = initialRequest.getRequestDispatcher(initialRequest.getServletPath());
    }

    public RenderHttpServletRequest withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public RenderHttpServletRequest to(String relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    public RenderHttpServletRequest withGetParameter(String name, String value) {
        if (!this.getParameters.containsKey(name)) {
            this.getParameters.put(name, new ArrayList());
        }
        this.getParameters.get(name).add(value);
        return this;
    }

    public RenderHttpServletRequest withPostParameter(String name, String value) {
        if (!this.postParameters.containsKey(name)) {
            this.postParameters.put(name, new ArrayList());
        }
        this.postParameters.get(name).add(value);
        return this;
    }

    public RenderHttpServletRequest withContent(InputStream inputStream) {
        this.content = inputStream;
        return this;
    }

    public RenderHttpServletRequest withContent(String content) {
        this.content = new ByteArrayInputStream(content.getBytes());
        return this;
    }

    public RenderHttpServletRequest withContentType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public String getMethod() {
        return this.method.name();
    }

    public String getPathInfo() {
        return this.relativeUrl;
    }

    public String getQueryString() {
        ArrayList<String> parameters = new ArrayList<String>();
        for (String getParameterKey : this.getParameters.keySet()) {
            for (String value : this.getParameters.get(getParameterKey)) {
                parameters.add(this.encode(getParameterKey) + URL_GET_ATTR + this.encode(value));
            }
        }
        return StringUtils.join(parameters, (String)URL_GET_SEPARATOR);
    }

    public String[] getParameterValues(String name) {
        ArrayList values = new ArrayList();
        if (this.getParameters.containsKey(name)) {
            values.addAll(this.getParameters.get(name));
        }
        if (this.postParameters.containsKey(name)) {
            values.addAll(this.postParameters.get(name));
        }
        return values.toArray(new String[values.size()]);
    }

    public Map getParameterMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.putAll(this.getParameters);
        map.putAll(this.postParameters);
        return map;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.content));
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + this.relativeUrl + ";jsessionid=" + this.getRequestedSessionId();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public int getContentLength() {
        try {
            return this.content == null ? 0 : this.content.available();
        }
        catch (IOException e) {
            LOG.error("Can't get the content size of the content body", (Throwable)e);
            return 0;
        }
    }

    public String getContentType() {
        return this.mediaType.getType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return RenderHttpServletRequest.this.content.read();
            }
        };
    }

    public String getParameter(String name) {
        List<String> values = null;
        values = !this.postParameters.containsKey(name) ? this.getParameters.get(name) : this.postParameters.get(name);
        return values.isEmpty() ? null : values.get(0);
    }

    public Enumeration getParameterNames() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(this.postParameters.keySet());
        vector.addAll(this.getParameters.keySet());
        return vector.elements();
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public String getPathTranslated() {
        return this.getRealPath(this.relativeUrl);
    }

    public String getAuthType() {
        return this.initialValues.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.initialValues.getCookies();
    }

    public long getDateHeader(String name) {
        return (Long)this.headers.get(name);
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public Enumeration getHeaders(String name) {
        return (Enumeration)this.headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return new Vector<String>(this.headers.keySet()).elements();
    }

    public int getIntHeader(String name) {
        return (Integer)this.headers.get(name);
    }

    public String getContextPath() {
        return this.initialValues.getContextPath();
    }

    public String getRemoteUser() {
        return this.initialValues.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        LOG.debug("Cannot check if user is in role");
        return false;
    }

    public Principal getUserPrincipal() {
        return this.initialValues.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.initialValues.getRequestedSessionId();
    }

    public String getServletPath() {
        return this.initialValues.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        LOG.error("Cannot create session in embedded rendering");
        return this.getSession();
    }

    public HttpSession getSession() {
        return this.initialValues.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.initialValues.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.initialValues.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.initialValues.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getCharacterEncoding() {
        return this.initialValues.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        LOG.warn("Unable to set the character encoding for embed requests");
    }

    public String getProtocol() {
        return this.initialValues.getProtocol();
    }

    public String getScheme() {
        return this.initialValues.getScheme();
    }

    public String getServerName() {
        return this.initialValues.getServerName();
    }

    public int getServerPort() {
        return this.initialValues.getServerPort();
    }

    public String getRemoteAddr() {
        return this.initialValues.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.initialValues.getRemoteHost();
    }

    public Locale getLocale() {
        return this.initialValues.getLocale();
    }

    public Enumeration getLocales() {
        return this.initialValues.getLocales();
    }

    public boolean isSecure() {
        return this.initialValues.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        LOG.debug("Returning the same request dispatcher everytime");
        return this.requestDispatcher;
    }

    public String getRealPath(String path) {
        return FilePath.path((String)this.realPath).append(path).toString();
    }

    public int getRemotePort() {
        return this.initialValues.getRemotePort();
    }

    public String getLocalName() {
        return this.initialValues.getLocalName();
    }

    public String getLocalAddr() {
        return this.initialValues.getLocalAddr();
    }

    public int getLocalPort() {
        return this.initialValues.getLocalPort();
    }

    private String encode(String value) {
        String encoding = Charset.defaultCharset().displayName();
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unable to find encoding " + encoding, (Throwable)e);
            return value;
        }
    }
}

