/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.info;

import com.networknt.config.Config;
import com.networknt.info.ServerInfoConfig;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoGetHandler
implements HttpHandler {
    public static final String CONFIG_NAME = "info";
    static final String STATUS_SERVER_INFO_DISABLED = "ERR10013";
    static final Logger logger = LoggerFactory.getLogger(ServerInfoGetHandler.class);

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ServerInfoConfig config = (ServerInfoConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ServerInfoConfig.class);
        if (config.isEnableServerInfo()) {
            LinkedHashMap<String, Object> infoMap = new LinkedHashMap<String, Object>();
            infoMap.put("deployment", this.getDeployment());
            infoMap.put("environment", this.getEnvironment(exchange));
            infoMap.put("specification", Config.getInstance().getJsonMapConfigNoCache("swagger"));
            infoMap.put("component", ModuleRegistry.getRegistry());
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(infoMap));
        } else {
            Status status = new Status(STATUS_SERVER_INFO_DISABLED, new Object[0]);
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
        }
    }

    public Map<String, Object> getDeployment() {
        LinkedHashMap<String, Object> deploymentMap = new LinkedHashMap<String, Object>();
        deploymentMap.put("apiVersion", Util.getJarVersion());
        deploymentMap.put("frameworkVersion", this.getFrameworkVersion());
        return deploymentMap;
    }

    public Map<String, Object> getEnvironment(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> envMap = new LinkedHashMap<String, Object>();
        envMap.put("host", this.getHost(exchange));
        envMap.put("runtime", this.getRuntime());
        envMap.put("system", this.getSystem());
        return envMap;
    }

    public Map<String, Object> getHost(HttpServerExchange exchange) {
        LinkedHashMap<String, Object> hostMap = new LinkedHashMap<String, Object>();
        String ip = "unknown";
        String hostname = "unknown";
        InetAddress inetAddress = Util.getInetAddress();
        ip = inetAddress.getHostAddress();
        hostname = inetAddress.getHostName();
        hostMap.put("ip", ip);
        hostMap.put("hostname", hostname);
        hostMap.put("dns", exchange.getSourceAddress().getHostName());
        return hostMap;
    }

    public Map<String, Object> getRuntime() {
        LinkedHashMap<String, Object> runtimeMap = new LinkedHashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        runtimeMap.put("availableProcessors", runtime.availableProcessors());
        runtimeMap.put("freeMemory", runtime.freeMemory());
        runtimeMap.put("totalMemory", runtime.totalMemory());
        runtimeMap.put("maxMemory", runtime.maxMemory());
        return runtimeMap;
    }

    public Map<String, Object> getSystem() {
        LinkedHashMap<String, Object> systemMap = new LinkedHashMap<String, Object>();
        Properties properties = System.getProperties();
        systemMap.put("javaVendor", properties.getProperty("java.vendor"));
        systemMap.put("javaVersion", properties.getProperty("java.version"));
        systemMap.put("osName", properties.getProperty("os.name"));
        systemMap.put("osVersion", properties.getProperty("os.version"));
        systemMap.put("userTimezone", properties.getProperty("user.timezone"));
        return systemMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFrameworkVersion() {
        String version = null;
        String path = "META-INF/maven/com.networknt/info/pom.properties";
        InputStream in = ClassLoader.getSystemResourceAsStream(path);
        try {
            Properties prop = new Properties();
            prop.load(in);
            version = prop.getProperty("version");
        }
        catch (Exception exception) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return version;
    }
}

