/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.impl.UnsafeChunkDecoder;
import com.ning.compress.lzf.impl.VanillaChunkDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkDecoderFactory {
    private static final ChunkDecoderFactory _instance;
    private final Class<? extends ChunkDecoder> _implClass;

    private ChunkDecoderFactory(Class<?> imp) {
        this._implClass = imp;
    }

    public static ChunkDecoder optimalInstance() {
        try {
            return ChunkDecoderFactory._instance._implClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load a ChunkDecoder instance (" + e.getClass().getName() + "): " + e.getMessage(), e);
        }
    }

    public static ChunkDecoder safeInstance() {
        return new VanillaChunkDecoder();
    }

    static {
        Class<Object> impl = null;
        try {
            impl = Class.forName(UnsafeChunkDecoder.class.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (impl == null) {
            impl = VanillaChunkDecoder.class;
        }
        _instance = new ChunkDecoderFactory(impl);
    }
}

