/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.http.codec.ChannelBufferUsageTracker;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\t1\u0011Ac\u00115b]:,GNQ;gM\u0016\u0014X*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0015\u0019w\u000eZ3d\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003\u001d1\u0017N\\1hY\u0016T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6\u001c\"\u0001A\u0007\u0011\u000599R\"A\b\u000b\u0005A\t\u0012aB2iC:tW\r\u001c\u0006\u0003%M\tQA\\3uifT!\u0001F\u000b\u0002\u000b)\u0014wn]:\u000b\u0003Y\t1a\u001c:h\u0013\tArB\u0001\u000bTS6\u0004H.Z\"iC:tW\r\u001c%b]\u0012dWM\u001d\u0005\t5\u0001\u0011\t\u0011)A\u00059\u0005aQo]1hKR\u0013\u0018mY6fe\u000e\u0001\u0001CA\u000f\u001f\u001b\u0005\u0011\u0011BA\u0010\u0003\u0005e\u0019\u0005.\u00198oK2\u0014UO\u001a4feV\u001b\u0018mZ3Ue\u0006\u001c7.\u001a:\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019C\u0005\u0005\u0002\u001e\u0001!)!\u0004\ta\u00019!1a\u0005\u0001Q!\n\u001d\n1BY;gM\u0016\u0014Xk]1hKB\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t!Aj\u001c8h\u0011\u0015q\u0003\u0001\"\u00110\u0003=iWm]:bO\u0016\u0014VmY3jm\u0016$Gc\u0001\u00194qA\u0011\u0001&M\u0005\u0003e%\u0012A!\u00168ji\")A'\fa\u0001k\u0005\u00191\r\u001e=\u0011\u000591\u0014BA\u001c\u0010\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ!O\u0017A\u0002i\n\u0011!\u001a\t\u0003\u001dmJ!\u0001P\b\u0003\u00195+7o]1hK\u00163XM\u001c;\t\u000by\u0002A\u0011I \u0002\u001b]\u0014\u0018\u000e^3D_6\u0004H.\u001a;f)\r\u0001\u0004)\u0011\u0005\u0006iu\u0002\r!\u000e\u0005\u0006su\u0002\rA\u0011\t\u0003\u001d\rK!\u0001R\b\u0003)]\u0013\u0018\u000e^3D_6\u0004H.\u001a;j_:,e/\u001a8u\u0011\u00151\u0005\u0001\"\u0011H\u00035\u0019\u0007.\u00198oK2\u001cEn\\:fIR\u0019\u0001\u0007S%\t\u000bQ*\u0005\u0019A\u001b\t\u000be*\u0005\u0019\u0001&\u0011\u00059Y\u0015B\u0001'\u0010\u0005E\u0019\u0005.\u00198oK2\u001cF/\u0019;f\u000bZ,g\u000e\u001e\u0005\u0007\u001d\u0002\u0001K\u0011B(\u0002'%t7M]3bg\u0016\u0014UO\u001a4feV\u001b\u0018mZ3\u0015\u0005A\u0002\u0006\"B)N\u0001\u00049\u0013\u0001B:ju\u0016Daa\u0015\u0001!\n\u0013!\u0016\u0001E2mK\u0006\u0014()\u001e4gKJ,6/Y4f)\u0005\u0001\u0004")
public class ChannelBufferManager
extends SimpleChannelHandler {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            this.increaseBufferUsage(channelBuffer.capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.messageReceived(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        this.clearBufferUsage();
        super.writeComplete(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.clearBufferUsage();
        super.channelClosed(ctx, e);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ChannelBufferManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

