/*
 * Decompiled with CFR 0.152.
 */
package parquet.io.api;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import parquet.bytes.BytesUtils;
import parquet.io.ParquetEncodingException;

public abstract class Binary {
    public static final Binary EMPTY = Binary.fromByteArray(new byte[0]);

    public static Binary fromByteArray(final byte[] value, final int offset, final int length) {
        return new Binary(){

            @Override
            public String toStringUsingUTF8() {
                return BytesUtils.UTF8.decode(ByteBuffer.wrap(value, offset, length)).toString();
            }

            @Override
            public int length() {
                return length;
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                out.write(value, offset, length);
            }

            @Override
            public byte[] getBytes() {
                return Arrays.copyOfRange(value, offset, offset + length);
            }

            public int hashCode() {
                return Binary.hashCode(value, offset, length);
            }

            @Override
            boolean equals(Binary other) {
                return other.equals(value, offset, length);
            }

            @Override
            boolean equals(byte[] other, int otherOffset, int otherLength) {
                return Binary.equals(value, offset, length, other, otherOffset, otherLength);
            }

            @Override
            public ByteBuffer toByteBuffer() {
                return ByteBuffer.wrap(value, offset, length);
            }

            @Override
            public void writeTo(DataOutput out) throws IOException {
                out.write(value, offset, length);
            }
        };
    }

    public static Binary fromByteArray(final byte[] value) {
        return new Binary(){

            @Override
            public String toStringUsingUTF8() {
                return new String(value, BytesUtils.UTF8);
            }

            @Override
            public int length() {
                return value.length;
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                out.write(value);
            }

            @Override
            public byte[] getBytes() {
                return value;
            }

            public int hashCode() {
                return Binary.hashCode(value, 0, value.length);
            }

            @Override
            boolean equals(Binary other) {
                return other.equals(value, 0, value.length);
            }

            @Override
            boolean equals(byte[] other, int otherOffset, int otherLength) {
                return Binary.equals(value, 0, value.length, other, otherOffset, otherLength);
            }

            @Override
            public ByteBuffer toByteBuffer() {
                return ByteBuffer.wrap(value);
            }

            @Override
            public void writeTo(DataOutput out) throws IOException {
                out.write(value);
            }
        };
    }

    public static Binary fromByteBuffer(final ByteBuffer value) {
        return new Binary(){

            @Override
            public String toStringUsingUTF8() {
                return new String(this.getBytes(), BytesUtils.UTF8);
            }

            @Override
            public int length() {
                return value.remaining();
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                out.write(this.getBytes());
            }

            @Override
            public byte[] getBytes() {
                byte[] bytes = new byte[value.remaining()];
                value.mark();
                value.get(bytes).reset();
                return bytes;
            }

            public int hashCode() {
                if (value.hasArray()) {
                    return Binary.hashCode(value.array(), value.arrayOffset() + value.position(), value.arrayOffset() + value.remaining());
                }
                byte[] bytes = this.getBytes();
                return Binary.hashCode(bytes, 0, bytes.length);
            }

            @Override
            boolean equals(Binary other) {
                if (value.hasArray()) {
                    return other.equals(value.array(), value.arrayOffset() + value.position(), value.arrayOffset() + value.remaining());
                }
                byte[] bytes = this.getBytes();
                return other.equals(bytes, 0, bytes.length);
            }

            @Override
            boolean equals(byte[] other, int otherOffset, int otherLength) {
                if (value.hasArray()) {
                    return Binary.equals(value.array(), value.arrayOffset() + value.position(), value.arrayOffset() + value.remaining(), other, otherOffset, otherLength);
                }
                byte[] bytes = this.getBytes();
                return Binary.equals(bytes, 0, bytes.length, other, otherOffset, otherLength);
            }

            @Override
            public ByteBuffer toByteBuffer() {
                return value;
            }

            @Override
            public void writeTo(DataOutput out) throws IOException {
                out.write(this.getBytes());
            }
        };
    }

    public static Binary fromString(String value) {
        try {
            return Binary.fromByteArray(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ParquetEncodingException("UTF-8 not supported.", e);
        }
    }

    private static final int hashCode(byte[] array, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            result = 31 * result + b;
        }
        return result;
    }

    private static final boolean equals(byte[] array1, int offset1, int length1, byte[] array2, int offset2, int length2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (length1 != length2) {
            return false;
        }
        if (array1 == array2 && offset1 == offset2) {
            return true;
        }
        for (int i = 0; i < length1; ++i) {
            if (array1[i + offset1] == array2[i + offset2]) continue;
            return false;
        }
        return true;
    }

    public abstract String toStringUsingUTF8();

    public abstract int length();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract void writeTo(DataOutput var1) throws IOException;

    public abstract byte[] getBytes();

    abstract boolean equals(byte[] var1, int var2, int var3);

    abstract boolean equals(Binary var1);

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Binary) {
            return this.equals((Binary)obj);
        }
        return false;
    }

    public abstract ByteBuffer toByteBuffer();

    public String toString() {
        return "Binary{" + this.length() + " bytes, " + this.toStringUsingUTF8() + "}";
    }
}

