/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncBiConsumer<T, U> {
    public Promise<Void> accept(T var1, U var2);

    @NotNull
    public static <T, U> AsyncBiConsumer<T, U> of(@NotNull BiConsumerEx<? super T, ? super U> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)consumer);
                return Promise.ofException(e);
            }
            return Promise.complete();
        };
    }
}

