/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.AsyncAccumulator;
import io.activej.async.function.AsyncPredicate;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.common.ref.RefBoolean;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class AsyncPredicates {
    @Contract(pure=true)
    @NotNull
    public static <T> AsyncPredicate<T> buffer(@NotNull AsyncPredicate<T> actual) {
        return AsyncPredicates.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> AsyncPredicate<T> buffer(int maxParallelCalls, int maxBufferedCalls, @NotNull AsyncPredicate<T> asyncPredicate) {
        return AsyncPredicates.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), asyncPredicate);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> AsyncPredicate<T> ofExecutor(@NotNull AsyncExecutor asyncExecutor, @NotNull AsyncPredicate<T> predicate) {
        return t -> asyncExecutor.execute(() -> predicate.test(t));
    }

    @NotNull
    public static <T> AsyncPredicate<T> and(Collection<AsyncPredicate<? super T>> predicates) {
        return t -> {
            AsyncAccumulator<RefBoolean> asyncAccumulator = AsyncAccumulator.create(new RefBoolean(true));
            for (AsyncPredicate predicate : predicates) {
                asyncAccumulator.addPromise(predicate.test(t), (ref, result) -> ref.set(ref.get() && result != false));
            }
            return asyncAccumulator.run().map(RefBoolean::get);
        };
    }

    @NotNull
    public static <T> AsyncPredicate<T> and() {
        return AsyncPredicate.alwaysTrue();
    }

    @NotNull
    public static <T> AsyncPredicate<T> and(AsyncPredicate<? super T> predicate1) {
        return predicate1;
    }

    @NotNull
    public static <T> AsyncPredicate<T> and(AsyncPredicate<? super T> predicate1, AsyncPredicate<? super T> predicate2) {
        return predicate1.and(predicate2);
    }

    @SafeVarargs
    @NotNull
    public static <T> AsyncPredicate<T> and(AsyncPredicate<? super T> ... predicates) {
        return AsyncPredicates.and(Arrays.asList(predicates));
    }

    @NotNull
    public static <T> AsyncPredicate<T> or(Collection<AsyncPredicate<? super T>> predicates) {
        return t -> {
            AsyncAccumulator<RefBoolean> asyncAccumulator = AsyncAccumulator.create(new RefBoolean(false));
            for (AsyncPredicate predicate : predicates) {
                asyncAccumulator.addPromise(predicate.test(t), (ref, result) -> ref.set(ref.get() || result != false));
            }
            return asyncAccumulator.run().map(RefBoolean::get);
        };
    }

    @NotNull
    public static <T> AsyncPredicate<T> or() {
        return AsyncPredicate.alwaysFalse();
    }

    @NotNull
    public static <T> AsyncPredicate<T> or(AsyncPredicate<? super T> predicate1) {
        return predicate1;
    }

    @NotNull
    public static <T> AsyncPredicate<T> or(AsyncPredicate<? super T> predicate1, AsyncPredicate<? super T> predicate2) {
        return predicate1.or(predicate2);
    }

    @SafeVarargs
    @NotNull
    public static <T> AsyncPredicate<T> or(AsyncPredicate<? super T> ... predicates) {
        return AsyncPredicates.or(Arrays.asList(predicates));
    }
}

