/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.AbstractPromise;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CompletePromise<T>
implements Promise<T> {
    CompletePromise() {
    }

    @Override
    public final boolean isComplete() {
        return true;
    }

    @Override
    public final boolean isResult() {
        return true;
    }

    @Override
    public final boolean isException() {
        return false;
    }

    @Override
    public final Exception getException() {
        return null;
    }

    @Override
    public Try<T> getTry() {
        return Try.of(this.getResult());
    }

    @Override
    @NotNull
    public final <U> Promise<U> next(@NotNull NextPromise<T, U> promise) {
        promise.accept(this.getResult(), null);
        return promise;
    }

    @Override
    @NotNull
    public final <U> Promise<U> map(@NotNull FunctionEx<? super T, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(this.getResult()));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> mapIfElse(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, ? extends U> fn, @NotNull FunctionEx<? super T, ? extends U> fnElse) {
        try {
            return Promise.of(predicate.test(this.getResult()) ? fn.apply(this.getResult()) : fnElse.apply(this.getResult()));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> mapIf(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, ? extends T> fn) {
        try {
            Object result = this.getResult();
            return Promise.of(predicate.test(result) ? fn.apply(result) : result);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> mapIfNull(@NotNull SupplierEx<? extends T> supplier) {
        try {
            Object result = this.getResult();
            return Promise.of(result == null ? supplier.get() : result);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> mapIfNonNull(@NotNull @NotNull FunctionEx<? super @NotNull T, ? extends U> fn) {
        try {
            Object result = this.getResult();
            return Promise.of(result != null ? fn.apply(result) : null);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public final <U> Promise<U> map(@NotNull BiFunctionEx<? super T, Exception, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(this.getResult(), null));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> map(@NotNull FunctionEx<? super T, ? extends U> fn, @NotNull @NotNull FunctionEx<@NotNull Exception, ? extends U> exceptionFn) {
        try {
            return Promise.of(fn.apply(this.getResult()));
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> mapException(@NotNull @NotNull FunctionEx<@NotNull Exception, Exception> exceptionFn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> mapException(@NotNull Predicate<Exception> predicate, @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> mapException(@NotNull Class<? extends Exception> clazz, @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        return this;
    }

    @Override
    @NotNull
    public final <U> Promise<U> then(@NotNull FunctionEx<? super T, Promise<? extends U>> fn) {
        try {
            return (Promise)fn.apply(this.getResult());
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> thenIfElse(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, Promise<? extends U>> fn, @NotNull FunctionEx<? super T, Promise<? extends U>> fnElse) {
        try {
            return predicate.test(this.getResult()) ? (Promise)fn.apply(this.getResult()) : (Promise)fnElse.apply(this.getResult());
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> thenIf(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, Promise<? extends T>> fn) {
        try {
            return predicate.test(this.getResult()) ? (Promise)fn.apply(this.getResult()) : this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> thenIfNull(@NotNull SupplierEx<Promise<? extends T>> supplier) {
        try {
            return this.getResult() == null ? (Promise)supplier.get() : this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> thenIfNonNull(@NotNull @NotNull FunctionEx<? super @NotNull T, Promise<? extends U>> fn) {
        try {
            Object result = this.getResult();
            return result != null ? (Promise)fn.apply(result) : this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull SupplierEx<Promise<? extends U>> fn) {
        try {
            return (Promise)fn.get();
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public final <U> Promise<U> then(@NotNull BiFunctionEx<? super T, Exception, Promise<? extends U>> fn) {
        try {
            return (Promise)fn.apply(this.getResult(), null);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> then(@NotNull FunctionEx<? super T, Promise<? extends U>> fn, @NotNull @NotNull FunctionEx<@NotNull Exception, Promise<? extends U>> exceptionFn) {
        try {
            return (Promise)fn.apply(this.getResult());
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @NotNull BiConsumerEx<? super T, Exception> fn) {
        try {
            if (predicate.test(this.getResult(), null)) {
                fn.accept(this.getResult(), null);
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @Nullable ConsumerEx<? super T> fn, @Nullable ConsumerEx<@NotNull Exception> exceptionFn) {
        try {
            if (predicate.test(this.getResult(), null)) {
                fn.accept(this.getResult());
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @NotNull RunnableEx action) {
        try {
            if (predicate.test(this.getResult(), null)) {
                action.run();
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull BiConsumerEx<? super T, Exception> fn) {
        try {
            fn.accept(this.getResult(), null);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull ConsumerEx<? super T> fn, @NotNull @NotNull ConsumerEx<@NotNull Exception> exceptionFn) {
        try {
            fn.accept(this.getResult());
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(@NotNull RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenResult(ConsumerEx<? super T> fn) {
        try {
            fn.accept(this.getResult());
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull Predicate<? super T> predicate, ConsumerEx<? super T> fn) {
        try {
            if (predicate.test(this.getResult())) {
                fn.accept(this.getResult());
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenResult(@NotNull Predicate<? super T> predicate, @NotNull RunnableEx action) {
        try {
            if (predicate.test(this.getResult())) {
                action.run();
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull ConsumerEx<Exception> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Predicate<Exception> predicate, @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Class<? extends Exception> clazz, @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull RunnableEx action) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Predicate<Exception> predicate, @NotNull RunnableEx action) {
        return this;
    }

    @Override
    @NotNull
    public Promise<T> whenException(@NotNull Class<? extends Exception> clazz, @NotNull RunnableEx action) {
        return this;
    }

    @Override
    @NotNull
    public final <U, V> Promise<V> combine(@NotNull Promise<? extends U> other, @NotNull BiFunctionEx<? super T, ? super U, ? extends V> fn) {
        return other.map(otherResult -> fn.apply(this.getResult(), otherResult)).whenException(() -> Recyclers.recycle(this.getResult()));
    }

    @Override
    @NotNull
    public final Promise<Void> both(@NotNull Promise<?> other) {
        Recyclers.recycle(this.getResult());
        return other.map(AbstractPromise::recycleToVoid);
    }

    @Override
    @NotNull
    public final Promise<T> either(@NotNull Promise<? extends T> other) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    @NotNull
    public final Promise<T> async() {
        SettablePromise result = new SettablePromise();
        Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext(result, () -> result.set(this.getResult())));
        return result;
    }

    @Override
    @NotNull
    public final Promise<Try<T>> toTry() {
        return Promise.of(Try.of(this.getResult()));
    }

    @Override
    @NotNull
    public final Promise<Void> toVoid() {
        return Promise.complete();
    }

    @Override
    public void run(@NotNull Callback<? super T> callback) {
        callback.accept(this.getResult(), null);
    }

    @Override
    @NotNull
    public final CompletableFuture<T> toCompletableFuture() {
        return CompletableFuture.completedFuture(this.getResult());
    }

    static {
        Recyclers.register(CompletePromise.class, promise -> Recyclers.recycle(promise.getResult()));
    }
}

