/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.AsyncComputation;
import io.activej.async.callback.Callback;
import io.activej.common.Checks;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.CompleteExceptionallyPromise;
import io.activej.promise.CompleteNullPromise;
import io.activej.promise.CompleteResultPromise;
import io.activej.promise.NextPromise;
import io.activej.promise.P;
import io.activej.promise.Promisable;
import io.activej.promise.SettablePromise;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Promise<T>
extends Promisable<T>,
AsyncComputation<T> {
    @NotNull
    public static Promise<Void> complete() {
        return CompleteNullPromise.INSTANCE;
    }

    @NotNull
    public static <T> Promise<T> of(@Nullable T value) {
        return value != null ? new CompleteResultPromise<T>(value) : CompleteNullPromise.instance();
    }

    @NotNull
    public static <T> Promise<T> ofException(@NotNull Exception e) {
        return new CompleteExceptionallyPromise(e);
    }

    @NotNull
    public static <T> Promise<T> ofCallback(@NotNull @NotNull ConsumerEx<@NotNull SettablePromise<T>> callbackConsumer) {
        SettablePromise cb = new SettablePromise();
        try {
            callbackConsumer.accept(cb);
        }
        catch (Exception ex) {
            FatalErrorHandlers.handleError((Throwable)ex, callbackConsumer);
            return Promise.ofException(ex);
        }
        return cb;
    }

    @NotNull
    public static <T> Promise<T> ofOptional(@NotNull Optional<T> optional) {
        return Promise.ofOptional(optional, NoSuchElementException::new);
    }

    @NotNull
    public static <T> Promise<T> ofOptional(@NotNull Optional<T> optional, @NotNull Supplier<? extends Exception> errorSupplier) {
        if (optional.isPresent()) {
            return Promise.of(optional.get());
        }
        return Promise.ofException(errorSupplier.get());
    }

    @NotNull
    public static <T> Promise<T> of(@Nullable T value, @Nullable Exception e) {
        Checks.checkArgument((value == null || e == null ? 1 : 0) != 0, (Object)"Either value or exception should be 'null'");
        return e == null ? Promise.of(value) : Promise.ofException(e);
    }

    @NotNull
    public static <T> Promise<T> ofTry(@NotNull Try<T> t) {
        return (Promise)t.reduce(Promise::of, Promise::ofException);
    }

    @NotNull
    public static <T> Promise<T> ofFuture(@NotNull CompletableFuture<? extends T> future) {
        return Promise.ofCompletionStage(future);
    }

    @NotNull
    public static <T> Promise<T> ofCompletionStage(CompletionStage<? extends T> completionStage) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            completionStage.whenCompleteAsync((result, throwable) -> {
                eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> {
                    if (throwable == null) {
                        cb.accept(result, null);
                    } else {
                        Exception e = FatalErrorHandlers.getExceptionOrThrowError((Throwable)throwable);
                        FatalErrorHandlers.handleError((Throwable)e, (Object)cb);
                        cb.accept(null, e);
                    }
                }));
                eventloop.completeExternalTask();
            });
        });
    }

    @NotNull
    public static <T> Promise<T> ofFuture(@NotNull Executor executor, @NotNull Future<? extends T> future) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        Object value = future.get();
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.set(value)));
                    }
                    catch (ExecutionException ex) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> {
                            Exception e = FatalErrorHandlers.getExceptionOrThrowError((Throwable)ex.getCause());
                            FatalErrorHandlers.handleError((Throwable)e, (Object)cb);
                            cb.setException(e);
                        }));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(e)));
                    }
                    catch (CancellationException e) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.setException(e)));
                    }
                    catch (Throwable throwable) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> {
                            Exception e = FatalErrorHandlers.getExceptionOrThrowError((Throwable)throwable);
                            FatalErrorHandlers.handleError((Throwable)e, (Object)cb);
                            cb.setException(e);
                        }));
                    }
                    finally {
                        eventloop.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                eventloop.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    public static <T> Promise<T> ofBlocking(@NotNull Executor executor, @NotNull SupplierEx<? extends T> supplier) {
        return Promise.ofCallback(cb -> {
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            eventloop.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        Object result = supplier.get();
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> cb.set(result)));
                    }
                    catch (Throwable throwable) {
                        eventloop.execute(RunnableWithContext.wrapContext((Object)cb, () -> {
                            Exception e = FatalErrorHandlers.getExceptionOrThrowError((Throwable)throwable);
                            FatalErrorHandlers.handleError((Throwable)e, (Object)cb);
                            cb.setException(e);
                        }));
                    }
                    finally {
                        eventloop.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                eventloop.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    @NotNull
    public static Promise<Void> ofBlocking(@NotNull Executor executor, @NotNull RunnableEx runnable) {
        return Promise.ofBlocking(executor, () -> {
            runnable.run();
            return null;
        });
    }

    @Override
    default public Promise<T> promise() {
        return this;
    }

    @Contract(pure=true)
    default public boolean isComplete() {
        return this.isResult() || this.isException();
    }

    @Contract(pure=true)
    public boolean isResult();

    @Contract(pure=true)
    public boolean isException();

    @Contract(pure=true)
    public T getResult();

    @Contract(pure=true)
    public Exception getException();

    @Contract(pure=true)
    public Try<T> getTry();

    @Contract(pure=true)
    @NotNull
    public Promise<T> async();

    @Contract(value="_ -> param1")
    @NotNull
    public <U> Promise<U> next(@NotNull NextPromise<T, U> var1);

    @NotNull
    public <U> Promise<U> map(@NotNull FunctionEx<? super T, ? extends U> var1);

    @NotNull
    default public <U> Promise<U> mapIfElse(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, ? extends U> fn, @NotNull FunctionEx<? super T, ? extends U> elseFn) {
        return this.map(t -> predicate.test(t) ? fn.apply(t) : elseFn.apply(t));
    }

    @NotNull
    default public Promise<T> mapIf(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, ? extends T> fn) {
        return this.mapIfElse(predicate, fn, FunctionEx.identity());
    }

    @NotNull
    default public Promise<T> mapIfNull(@NotNull SupplierEx<? extends T> supplier) {
        return this.mapIf(Objects::isNull, $ -> supplier.get());
    }

    @NotNull
    default public <U> Promise<U> mapIfNonNull(@NotNull @NotNull FunctionEx<? super @NotNull T, ? extends U> fn) {
        return this.mapIfElse(Objects::nonNull, fn, $ -> null);
    }

    @NotNull
    public <U> Promise<U> map(@NotNull BiFunctionEx<? super T, @Nullable Exception, ? extends U> var1);

    @NotNull
    default public <U> Promise<U> map(@NotNull FunctionEx<? super T, ? extends U> fn, @NotNull @NotNull FunctionEx<@NotNull Exception, ? extends U> exceptionFn) {
        return this.map((v, e) -> e == null ? fn.apply(v) : exceptionFn.apply(e));
    }

    @NotNull
    default public Promise<T> mapException(@NotNull @NotNull FunctionEx<@NotNull Exception, Exception> exceptionFn) {
        return this.then(Promise::of, e -> Promise.ofException((Exception)exceptionFn.apply(e)));
    }

    @NotNull
    default public Promise<T> mapException(@NotNull Predicate<Exception> predicate, @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        return this.mapException((FunctionEx<Exception, Exception>)((FunctionEx)e -> predicate.test((Exception)e) ? (Exception)exceptionFn.apply(e) : e));
    }

    @NotNull
    default public Promise<T> mapException(@NotNull Class<? extends Exception> clazz, @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        return this.mapException((Exception e) -> clazz.isAssignableFrom(e.getClass()), exceptionFn);
    }

    @NotNull
    public <U> Promise<U> then(@NotNull SupplierEx<Promise<? extends U>> var1);

    @NotNull
    public <U> Promise<U> then(@NotNull FunctionEx<? super T, Promise<? extends U>> var1);

    @NotNull
    default public <U> Promise<U> thenIfElse(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, Promise<? extends U>> fn, @NotNull FunctionEx<? super T, Promise<? extends U>> elseFn) {
        return this.then(t -> predicate.test(t) ? (Promise)fn.apply(t) : (Promise)elseFn.apply(t));
    }

    @NotNull
    default public Promise<T> thenIf(@NotNull Predicate<? super T> predicate, @NotNull FunctionEx<? super T, Promise<? extends T>> fn) {
        return this.thenIfElse(predicate, fn, Promise::of);
    }

    @NotNull
    default public Promise<T> thenIfNull(@NotNull SupplierEx<Promise<? extends T>> supplier) {
        return this.thenIfElse(Objects::isNull, $ -> (Promise)supplier.get(), Promise::of);
    }

    @NotNull
    default public <U> Promise<U> thenIfNonNull(@NotNull @NotNull FunctionEx<? super @NotNull T, Promise<? extends U>> fn) {
        return this.thenIfElse(Objects::nonNull, fn, $ -> Promise.of(null));
    }

    @NotNull
    public <U> Promise<U> then(@NotNull BiFunctionEx<? super T, @Nullable Exception, Promise<? extends U>> var1);

    @NotNull
    default public <U> Promise<U> then(@NotNull FunctionEx<? super T, Promise<? extends U>> fn, @NotNull @NotNull FunctionEx<@NotNull Exception, Promise<? extends U>> exceptionFn) {
        return this.then((v, e) -> e == null ? (Promise)fn.apply(v) : (Promise)exceptionFn.apply(e));
    }

    @NotNull
    default public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @NotNull BiConsumerEx<? super T, Exception> fn) {
        return this.then((v, e) -> {
            if (predicate.test((Object)v, (Exception)e)) {
                fn.accept(v, e);
            }
            return Promise.of(v, e);
        });
    }

    @NotNull
    default public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @Nullable ConsumerEx<? super T> fn, @Nullable ConsumerEx<@NotNull Exception> exceptionFn) {
        return this.when(predicate, (v, e) -> {
            if (e == null) {
                fn.accept(v);
            } else {
                exceptionFn.accept(e);
            }
        });
    }

    @NotNull
    default public Promise<T> when(@NotNull BiPredicate<? super T, @Nullable Exception> predicate, @NotNull RunnableEx action) {
        return this.when(predicate, (v, e) -> action.run());
    }

    @NotNull
    default public Promise<T> whenComplete(@NotNull BiConsumerEx<? super T, Exception> fn) {
        return this.when(P.isComplete(), fn);
    }

    @NotNull
    default public Promise<T> whenComplete(ConsumerEx<? super T> fn, ConsumerEx<@NotNull Exception> exceptionFn) {
        return this.when(P.isComplete(), fn, exceptionFn);
    }

    @NotNull
    default public Promise<T> whenComplete(@NotNull RunnableEx action) {
        return this.when(P.isComplete(), action);
    }

    @NotNull
    default public Promise<T> whenResult(ConsumerEx<? super T> fn) {
        return this.when(P.isResult(), fn, null);
    }

    @NotNull
    default public Promise<T> whenResult(@NotNull Predicate<? super T> predicate, ConsumerEx<? super T> fn) {
        return this.when(P.isResult(predicate), fn, null);
    }

    @NotNull
    default public Promise<T> whenResult(@NotNull RunnableEx action) {
        return this.when(P.isResult(), action);
    }

    @NotNull
    default public Promise<T> whenResult(@NotNull Predicate<? super T> predicate, @NotNull RunnableEx action) {
        return this.when(P.isResult(predicate), action);
    }

    @NotNull
    default public Promise<T> whenException(@NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        return this.when(P.isException(), null, fn);
    }

    @NotNull
    default public Promise<T> whenException(@NotNull Predicate<Exception> predicate, @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        return this.when(P.isException(predicate), null, fn);
    }

    @NotNull
    default public Promise<T> whenException(@NotNull Class<? extends Exception> clazz, @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        return this.when(P.isException(clazz), null, fn);
    }

    @NotNull
    default public Promise<T> whenException(@NotNull RunnableEx action) {
        return this.when(P.isException(), action);
    }

    @NotNull
    default public Promise<T> whenException(@NotNull Predicate<Exception> predicate, @NotNull RunnableEx action) {
        return this.when(P.isException(predicate), action);
    }

    @NotNull
    default public Promise<T> whenException(@NotNull Class<? extends Exception> clazz, @NotNull RunnableEx action) {
        return this.when(P.isException(clazz), action);
    }

    @NotNull
    default public <U> Promise<U> cast() {
        return this;
    }

    @NotNull
    default public <U> Promise<U> cast(Class<? extends U> cls) {
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public <U, V> Promise<V> combine(@NotNull Promise<? extends U> var1, @NotNull BiFunctionEx<? super T, ? super U, ? extends V> var2);

    @Contract(pure=true)
    @NotNull
    public Promise<Void> both(@NotNull Promise<?> var1);

    @Contract(pure=true)
    @NotNull
    public Promise<T> either(@NotNull Promise<? extends T> var1);

    @Contract(pure=true)
    @NotNull
    public Promise<Try<T>> toTry();

    @Contract(pure=true)
    @NotNull
    public Promise<Void> toVoid();

    public void run(@NotNull Callback<? super T> var1);

    @Contract(pure=true)
    @NotNull
    public CompletableFuture<T> toCompletableFuture();
}

