/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server.testing;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.LocalAnnouncementHttpServerInfo;
import io.airlift.http.server.TheServlet;
import io.airlift.http.server.testing.TestingHttpServer;
import javax.servlet.Filter;

public class TestingHttpServerModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        int threads = Math.max(10, Runtime.getRuntime().availableProcessors());
        HttpServerConfig config = new HttpServerConfig().setMinThreads(1).setMaxThreads(threads).setHttpPort(0);
        binder.bind(HttpServerConfig.class).toInstance((Object)config);
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(TestingHttpServer.class).in(Scopes.SINGLETON);
        binder.bind(HttpServer.class).to(Key.get(TestingHttpServer.class));
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class);
    }
}

