/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.ExceptionMapperContext;
import com.sun.jersey.spi.container.WebApplication;
import io.airlift.http.server.TheServlet;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.OverrideMethodFilter;
import io.airlift.jaxrs.ParsingExceptionMapper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.ws.rs.ext.Providers;

public class JaxrsModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(GuiceContainer.class).in(Scopes.SINGLETON);
        binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(Key.get(GuiceContainer.class));
        binder.bind(JsonMapper.class).in(Scopes.SINGLETON);
        binder.bind(ParsingExceptionMapper.class).in(Scopes.SINGLETON);
    }

    @Provides
    @TheServlet
    public Map<String, String> createTheServletParams() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("com.sun.jersey.spi.container.ContainerRequestFilters", OverrideMethodFilter.class.getName());
        return initParams;
    }

    @Provides
    public WebApplication webApp(GuiceContainer guiceContainer) {
        return guiceContainer.getWebApplication();
    }

    @Provides
    public Providers providers(WebApplication webApplication) {
        return webApplication.getProviders();
    }

    @Provides
    public FeaturesAndProperties featuresAndProperties(WebApplication webApplication) {
        return webApplication.getFeaturesAndProperties();
    }

    @Provides
    public MessageBodyWorkers messageBodyWorkers(WebApplication webApplication) {
        return webApplication.getMessageBodyWorkers();
    }

    @Provides
    public ExceptionMapperContext exceptionMapperContext(WebApplication webApplication) {
        return webApplication.getExceptionMapperContext();
    }
}

