/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.servlets.IncludableGzipFilter;

public class BiDiGzipFilter
extends IncludableGzipFilter {
    private final ThreadLocal<Inflater> localInflater = new ThreadLocal();
    private boolean inflateNoWrap = true;

    public Set<String> getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(Set<String> mimeTypes) {
        this._mimeTypes.clear();
        this._mimeTypes.addAll(mimeTypes);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }

    public int getDeflateCompressionLevel() {
        return this._deflateCompressionLevel;
    }

    public void setDeflateCompressionLevel(int level) {
        this._deflateCompressionLevel = level;
    }

    public boolean isDeflateNoWrap() {
        return this._deflateNoWrap;
    }

    public void setDeflateNoWrap(boolean noWrap) {
        this._deflateNoWrap = noWrap;
    }

    public boolean isInflateNoWrap() {
        return this.inflateNoWrap;
    }

    public void setInflateNoWrap(boolean inflateNoWrap) {
        this.inflateNoWrap = inflateNoWrap;
    }

    public Set<String> getMethods() {
        return this._methods;
    }

    public void setMethods(Set<String> methods) {
        this._methods.clear();
        this._methods.addAll(methods);
    }

    public Set<String> getExcludedAgents() {
        return this._excludedAgents;
    }

    public void setExcludedAgents(Set<String> userAgents) {
        this._excludedAgents = userAgents;
    }

    public Set<Pattern> getExcludedAgentPatterns() {
        return this._excludedAgentPatterns;
    }

    public void setExcludedAgentPatterns(Set<Pattern> userAgentPatterns) {
        this._excludedAgentPatterns = userAgentPatterns;
    }

    public String getVary() {
        return this._vary;
    }

    public void setVary(String vary) {
        this._vary = vary;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String encoding = request.getHeader(HttpHeader.CONTENT_ENCODING.asString());
        if ("gzip".equalsIgnoreCase(encoding)) {
            super.doFilter(this.wrapGzippedRequest(this.removeContentEncodingHeader(request)), res, chain);
        } else if ("deflate".equalsIgnoreCase(encoding)) {
            super.doFilter(this.wrapDeflatedRequest(this.removeContentEncodingHeader(request)), res, chain);
        } else {
            super.doFilter(req, res, chain);
        }
    }

    private Inflater buildInflater() {
        Inflater inflater = this.localInflater.get();
        if (inflater != null) {
            this.localInflater.set(null);
            inflater.reset();
            return inflater;
        }
        return new Inflater(this.inflateNoWrap);
    }

    private ServletRequest wrapDeflatedRequest(HttpServletRequest request) throws IOException {
        final Inflater inflater = this.buildInflater();
        InflaterInputStream input = new InflaterInputStream((InputStream)request.getInputStream(), inflater, this._bufferSize){

            @Override
            public void close() throws IOException {
                super.close();
                BiDiGzipFilter.this.localInflater.set(inflater);
            }
        };
        return new WrappedServletRequest(request, input);
    }

    private ServletRequest wrapGzippedRequest(HttpServletRequest request) throws IOException {
        return new WrappedServletRequest(request, new GZIPInputStream((InputStream)request.getInputStream(), this._bufferSize));
    }

    private HttpServletRequest removeContentEncodingHeader(HttpServletRequest request) {
        return new RemoveHttpHeaderWrapper(request, HttpHeader.CONTENT_ENCODING.asString());
    }

    private static class RemoveHttpHeaderWrapper
    extends HttpServletRequestWrapper {
        private final String headerName;

        public RemoveHttpHeaderWrapper(HttpServletRequest request, String headerName) {
            super(request);
            this.headerName = headerName;
        }

        public int getIntHeader(String name) {
            if (this.headerName.equalsIgnoreCase(name)) {
                return -1;
            }
            return super.getIntHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            if (this.headerName.equalsIgnoreCase(name)) {
                return Collections.emptyEnumeration();
            }
            return super.getHeaders(name);
        }

        public String getHeader(String name) {
            if (this.headerName.equalsIgnoreCase(name)) {
                return null;
            }
            return super.getHeader(name);
        }

        public long getDateHeader(String name) {
            if (this.headerName.equalsIgnoreCase(name)) {
                return -1L;
            }
            return super.getDateHeader(name);
        }
    }

    private static class WrappedServletInputStream
    extends ServletInputStream {
        private final InputStream input;

        private WrappedServletInputStream(InputStream input) {
            this.input = input;
        }

        public void close() throws IOException {
            this.input.close();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        public int available() throws IOException {
            return this.input.available();
        }

        public void mark(int readlimit) {
            this.input.mark(readlimit);
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public void reset() throws IOException {
            this.input.reset();
        }

        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }

        public boolean isFinished() {
            try {
                return this.input.available() == 0;
            }
            catch (IOException iOException) {
                return true;
            }
        }

        public boolean isReady() {
            try {
                return this.input.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }

    private static class WrappedServletRequest
    extends HttpServletRequestWrapper {
        private final ServletInputStream input;
        private final BufferedReader reader;

        private WrappedServletRequest(HttpServletRequest request, InputStream inputStream) throws IOException {
            super(request);
            this.input = new WrappedServletInputStream(inputStream);
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.input, this.getCharset()));
        }

        private Charset getCharset() {
            String encoding = this.getCharacterEncoding();
            if (encoding == null || !Charset.isSupported(encoding)) {
                return StandardCharsets.ISO_8859_1;
            }
            return Charset.forName(encoding);
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.input;
        }

        public BufferedReader getReader() throws IOException {
            return this.reader;
        }
    }
}

